#ifndef _MAIN_H_
#define _MAIN_H_
int button_offset_posion[6]={0,};
bool encoder_check[6]={false,false,false,false,false,false};
bool motor_onoff[6]={true,true,true,true,true,true};
int encoder_data[6]={0,0,0,0,0,0};

double motor_gain[6]={1,1,1,1,1,1};

double Speed_Pgain[6]={ 3,
                        3,
                        3,
                        3,
                        3,
                        3};
                        
double Speed_Igain[6]={ 0.01,
                        0.01,
                        0.01,
                        0.01,
                        0.01,
                        0.01};
                        
double position_Pgain[6]
                     ={ 10,
                        10,
                        10,
                        10,
                        10,
                        10};
                        
double Position_input_filter[6]
                     ={ 0.05,
                        0.05,
                        0.05,
                        0.05,
                        0.05,
                        0.05};             
double Speed_I_input_filter[6]
                     ={ 0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1,
                        0.1};

double offset[6]={      1500,
                        1500,
                        1500,
                        1500,
                        1500,
                        1500};


// SPI
#define SPI_MOSI1       PA_7
#define SPI_MISO1       PA_6
#define SPI_SCK1        PA_5

// Encoder
#define ENCODER_CS1     PB_0
#define ENCODER_CS2     PC_1
#define ENCODER_CS3     PC_0
#define ENCODER_CS4     PB_15
#define ENCODER_CS5     PB_14
#define ENCODER_CS6     PB_13

// Limit switch
#define LIMIT_SW1       PC_3
#define LIMIT_SW2       PC_2
#define LIMIT_SW3       PC_5
#define LIMIT_SW4       PC_9
#define LIMIT_SW5       PC_6
#define LIMIT_SW6       PC_8

// Motor
#define MOTOR_PWM1      PA_15
#define MOTOR_PWM2      PA_9
#define MOTOR_PWM3      PA_8
#define MOTOR_PWM4      PB_10
#define MOTOR_PWM5      PB_3
#define MOTOR_PWM6      PA_10
#define MOTOR_PWM7      PB_11

#include "idle_check.h"
#include "flash.h"
#include "spi_setup.h"
#include "pc_serial.h"
#include "motor.h"
#include "encoder.h"
#include "speed_pid.h"
#include "target_position_cal.h"
#include "Position.h"
#include "limit.h"
#include "button.h"


void board_init()
{
    Serial_Init();
    if(Flash_Head_Check() == true)
    {
        for(int i = 1; i < 7; i++)
        {
            set_data[i * 10]     = (double)Read_Flash(i * 40);
            set_data[i * 10 + 1] = (double)Read_Flash(i * 40 + 4);
            set_data[i * 10 + 2] = (double)Read_Flash(i * 40 + 8);
            set_data[i * 10 + 3] = (double)Read_Flash(i * 40 + 12);
            set_data[i * 10 + 4] = (double)Read_Flash(i * 40 + 16);
            set_data[i * 10 + 5] = (double)Read_Flash(i * 40 + 20);
        }
    }
    else
    {
        for(int i=0;i<6;i++)
        {
            set_data[(i+1)*10+0]=Speed_Pgain[i];
            set_data[(i+1)*10+1]=Speed_Igain[i];
            set_data[(i+1)*10+2]=position_Pgain[i];
            set_data[(i+1)*10+3]=Position_input_filter[i];
            set_data[(i+1)*10+4]=Speed_I_input_filter[i];
            set_data[(i+1)*10+5]=offset[i];
        }
    }

    limit_init();
    spi_init();
    motor_init();
    Serial_Init();
    
}

#endif
