#ifndef _FLASH_H_
#define _FLASH_H_

// ST32F103RBT6 - FLASH : 128KB, SRAM : 20KB (Medium-density model) 
// flash memory page : 127 (last page)
// flash memory size : 1KB, unit : Word(4Byte)
// 0x0801 FC00 - 0x0801 FFFF
#define FLASH_START_ADDRESS ((uint32_t)0x0801FC00)
#define FLASH_END_ADDRESS   ((uint32_t)0x0801FFFF)

#define FLASH_START_ADDRESS2 ((uint32_t)0x0801F800)
#define FLASH_END_ADDRESS2   ((uint32_t)0x0801FBFF)

uint32_t flash_address_count = 0;

bool Flash_Head_Check();
void Erase_Flash();
void Write_Flash(uint32_t data);
uint32_t Read_Flash(uint32_t address);

bool Flash_Head_Check()
{
    uint32_t flash_data[5];
    for(uint32_t i = 0; i < 5; i++)
    {
        flash_data[i] = Read_Flash(i * 4);
    }
    
    if  (  (char)flash_data[0] == 'F'
        && (char)flash_data[1] == 'L'
        && (char)flash_data[2] == 'A'
        && (char)flash_data[3] == 'S'
        && (char)flash_data[4] == 'H')
    {
        return true;
    } 
    else
    {
        return false;
    }
}


void Erase_Flash()
{
    static FLASH_EraseInitTypeDef flash_struct;                 // Flash erase struct
    uint32_t PageError = 0;                                     // Page error state
    
    flash_struct.TypeErase = FLASH_TYPEERASE_PAGES;             // Erase type : Page
    flash_struct.PageAddress = FLASH_START_ADDRESS;             // Flash start address
    flash_struct.NbPages = 1;                                   // Number of page

    HAL_FLASH_Unlock();                                         // Flash control unlock
    if(HAL_FLASHEx_Erase(&flash_struct, &PageError) != HAL_OK)  // Flash erase function & result, HAL_OK = true
    {
        //pc.printf("Flash erase error!\n\r");
    }
    HAL_FLASH_Lock();                                           // Flash control lock
    flash_address_count = 0;                                    // Flash address count variable reset
}


void Write_Flash(uint32_t data)
{
    if(Read_Flash(flash_address_count * 4))
    {
        HAL_FLASH_Unlock();
        HAL_FLASH_Program(FLASH_TYPEPROGRAM_WORD, FLASH_START_ADDRESS + (flash_address_count * 4), data);        
        HAL_FLASH_Lock();
    }
    flash_address_count++;
}

uint32_t Read_Flash(uint32_t address)
{
    uint32_t val = 0;
    address = address + FLASH_START_ADDRESS;
    val = *(__IO uint32_t*)address;
    
    return val;
}


#endif

