#ifndef _7_SEGMENT_H_
#define _7_SEGMENT_H_

#include "MCP23S17.h"

#define SEG_DELAY_TIME  (int)3
#define SEG_OE_PERIOD   (int)1500 // 1.5 ms

#define SEG_PGAIN 0
#define SEG_INPUT 0


//FastPWM OE_pin(PB_11, -1);
//PwmOut OE_pin(PB_11);
//DigitalOut output_enable_pin(PB_11);
bool OE_state = false;

uint8_t menual_step = 0;
uint32_t menual_delay = 0;

const bool num_data[10][8] =    {
                                    {1,0,0,0,0,0,0,1},
                                    {1,1,1,1,0,0,1,1},
                                    {0,1,0,0,1,0,0,1},
                                    {0,1,1,0,0,0,0,1},
                                    {0,0,1,1,0,0,1,1},
                                    {0,0,1,0,0,1,0,1},
                                    {0,0,0,0,0,1,0,1},
                                    {1,0,1,1,0,0,0,1},
                                    {0,0,0,0,0,0,0,1},
                                    {0,0,1,1,0,0,0,1},
                                };
                                
const bool menual_data[70][8] =    {                                
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 0, 0, 0, 1, 1, 0, 1}, 
                                            {1, 1, 1, 0, 0, 1, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                                                            
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 0, 0, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 1, 0, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                                                            
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 0, 0, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 1, 0, 0, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                                                            
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 0, 0, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 0, 0, 0, 1},
                                            {1, 1, 1, 1, 1, 1, 0, 1},
                                                                            
                                            {1, 1, 1, 1, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 0, 0, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 0, 0, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                                                            
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 1, 1, 1, 0, 1},
                                            {1, 0, 0, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 0, 0, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                                                            
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 0, 0, 1, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 0, 0, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                                                            
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 0, 1, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 0, 0, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                                                            
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 1, 0, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 0, 0, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                                                            
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 0, 0, 0, 1, 1, 1, 1},
                                            {1, 1, 1, 0, 0, 0, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                                                            
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 1, 1},
                                            {1, 0, 0, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 0, 0, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                                                            
                                            {1, 1, 1, 0, 1, 1, 1, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 0, 0, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 0, 0, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                                                            
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 0, 0, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 0, 0, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 1, 1},
                                                                            
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                            {1, 0, 0, 0, 1, 1, 0, 1},
                                            {1, 1, 1, 0, 0, 0, 1, 1},
                                            {1, 1, 1, 0, 1, 1, 0, 1},
                                         };
                                
int Gobal_GPIOA = 0x00;

void Segment_Init();
void Segment_PWM_Control();
void pgain_Latch_pin(bool logic);
void pgain_Clock_pin(bool logic);
void pgain_data_pin(bool logic);
void input_Latch_pin(bool logic);
void input_Clock_pin(bool logic);
void input_data_pin(bool logic);
void Pgain_segment(int num1,int num2,int num3,int delay_time_us);
void Input_segment(int num1,int num2,int delay_time_us);

void Menual_Segment();

void Segment_Init()
{
    Pgain_segment(0, 0, 0, SEG_DELAY_TIME);
    Input_segment(0, 0, SEG_DELAY_TIME);
    //output_enable_pin = 1;
//    OE_pin.period(0.015);
//    OE_pin.write(0.5f);
}
/*
void Segment_PWM_Control()
{
    output_enable_pin = OE_state;
    OE_state = !OE_state;
}
*/
void pgain_Latch_pin(bool logic) //GPA2
{
    if(logic)
        Gobal_GPIOA |= (1<<2);//LED를 켠다.
    else
        Gobal_GPIOA &= ~(1<<2);//LED를 끈다.
        
    MCP_Write(MCP_SEG_CS, MCP_GPIOA, Gobal_GPIOA);
}

void pgain_Clock_pin(bool logic) //GPA3
{
    if(logic)
        Gobal_GPIOA |= (1<<3);//LED를 켠다.
    else
        Gobal_GPIOA &= ~(1<<3);//LED를 끈다.
        
    MCP_Write(MCP_SEG_CS, MCP_GPIOA, Gobal_GPIOA);
}

void pgain_data_pin(bool logic) //GPA0
{
    if(logic)
        Gobal_GPIOA |= (1<<0);//LED를 켠다.
    else
        Gobal_GPIOA &= ~(1<<0);//LED를 끈다.
        
    MCP_Write(MCP_SEG_CS, MCP_GPIOA, Gobal_GPIOA);
}

void input_Latch_pin(bool logic) //GPA6
{
    if(logic)
        Gobal_GPIOA |= (1<<6);//LED를 켠다.
    else
        Gobal_GPIOA &= ~(1<<6);//LED를 끈다.
        
    MCP_Write(MCP_SEG_CS, MCP_GPIOA, Gobal_GPIOA);
}

void input_Clock_pin(bool logic) //GPA7
{
    if(logic)
        Gobal_GPIOA |= (1<<7);//LED를 켠다.
    else
        Gobal_GPIOA &= ~(1<<7);//LED를 끈다.
        
    MCP_Write(MCP_SEG_CS, MCP_GPIOA, Gobal_GPIOA);
}

void input_data_pin(bool logic) //GPA4
{
    if(logic)
        Gobal_GPIOA |= (1<<4);//LED를 켠다.
    else
        Gobal_GPIOA &= ~(1<<4);//LED를 끈다.
        
    MCP_Write(MCP_SEG_CS, MCP_GPIOA, Gobal_GPIOA);
}

void Pgain_segment(int num1,int num2,int num3,int delay_time_us)
{
    pgain_Latch_pin(0);
    wait_us(delay_time_us);
    
    if(num1>9)
        num1=9;
    if(num1<0)
        num1=0;
        
    if(num2>9)
        num2=9;
    if(num2<0)
        num2=0;
        
    if(num3>9)
        num3=9;
    if(num3<0)
        num3=0;
        
        
    for(int i=0;i<8;i++)
            {
                pgain_Clock_pin(1);
                wait_us(delay_time_us);
                pgain_data_pin(num_data[num3][i]);
                wait_us(delay_time_us);
                pgain_Clock_pin(0);
                wait_us(delay_time_us);
            }
    for(int i=0;i<8;i++)
            {
                pgain_Clock_pin(1);
                wait_us(delay_time_us);
                pgain_data_pin(num_data[num2][i]);
                wait_us(delay_time_us);
                pgain_Clock_pin(0);
                wait_us(delay_time_us);
            }
    for(int i=0;i<8;i++)
            {
                pgain_Clock_pin(1);
                wait_us(delay_time_us);
                pgain_data_pin(num_data[num1][i]);
                wait_us(delay_time_us);
                pgain_Clock_pin(0);
                wait_us(delay_time_us);
            }
    wait_us(delay_time_us);
    pgain_Latch_pin(1);
}

void Input_segment(int num1,int num2,int delay_time_us)
{
    input_Latch_pin(0);
    wait_us(delay_time_us);
    
    if(num1>9)
        num1=9;
    if(num1<0)
        num1=0;
        
    if(num2>9)
        num2=9;
    if(num2<0)
        num2=0;
        
    for(int i=0;i<8;i++)
            {
                input_Clock_pin(1);
                wait_us(delay_time_us);
                input_data_pin(num_data[num2][i]);
                wait_us(delay_time_us);
                input_Clock_pin(0);
                wait_us(delay_time_us);
            }
    for(int i=0;i<8;i++)
            {
                input_Clock_pin(1);
                wait_us(delay_time_us);
                input_data_pin(num_data[num1][i]);
                wait_us(delay_time_us);
                input_Clock_pin(0);
                wait_us(delay_time_us);
            }
    wait_us(delay_time_us);
    input_Latch_pin(1);
}

void Menual_Segment()
{
    menual_delay++;
    
    if(menual_delay > 333)
    {
        pgain_Latch_pin(0);
        wait_us(SEG_DELAY_TIME);
            
        for(int i=0;i<8;i++)
                {
                    pgain_Clock_pin(1);
                    wait_us(SEG_DELAY_TIME);
                    pgain_data_pin(menual_data[menual_step][i]);
                    wait_us(SEG_DELAY_TIME);
                    pgain_Clock_pin(0);
                    wait_us(SEG_DELAY_TIME);
                }
        for(int i=0;i<8;i++)
                {
                    pgain_Clock_pin(1);
                    wait_us(SEG_DELAY_TIME);
                    pgain_data_pin(menual_data[menual_step + 1][i]);
                    wait_us(SEG_DELAY_TIME);
                    pgain_Clock_pin(0);
                    wait_us(SEG_DELAY_TIME);
                }
        for(int i=0;i<8;i++)
                {
                    pgain_Clock_pin(1);
                    wait_us(SEG_DELAY_TIME);
                    pgain_data_pin(menual_data[menual_step + 2][i]);
                    wait_us(SEG_DELAY_TIME);
                    pgain_Clock_pin(0);
                    wait_us(SEG_DELAY_TIME);
                }
        wait_us(SEG_DELAY_TIME);
        pgain_Latch_pin(1);
        
        
        input_Latch_pin(0);
        wait_us(SEG_DELAY_TIME);
        
        for(int i=0;i<8;i++)
                {
                    input_Clock_pin(1);
                    wait_us(SEG_DELAY_TIME);                
                    input_data_pin(menual_data[menual_step + 3][i]);
                    wait_us(SEG_DELAY_TIME);
                    input_Clock_pin(0);
                    wait_us(SEG_DELAY_TIME);
                }
                    
        for(int i=0;i<8;i++)
                {
                    input_Clock_pin(1);
                    wait_us(SEG_DELAY_TIME);                
                    input_data_pin(menual_data[menual_step + 4][i]);
                    wait_us(SEG_DELAY_TIME);
                    input_Clock_pin(0);
                    wait_us(SEG_DELAY_TIME);
                }
                
        wait_us(SEG_DELAY_TIME);
        input_Latch_pin(1);
        
        menual_step += 5;
        
        if(menual_step > 65) menual_step = 0;
        menual_delay = 0;
    }
}

#endif
