/**********************************************************************
 ESP-01 BOARD RELAY CONTROL
 ==========================
AT+RST Reset ESP-01
AT+CWMODE Set ESP-01 mode (here it is set to Station mode)
AT+CWJAP Set Wi-Fi ssid name and password
AT+CPIMUX Set connection mode (here it is set to multiple connection)
AT+CIFSR Returns the IP address (not used here)
AT+CIPSTART Set TCP or UDP connection mode, destination IP address, and port number (here, UDP is used
with port number set to 5000. Destination IP address is set to “0.0.0.0” so that any device can
connect and send data over Port 5000).


Testing the Program
The program can easily be tested with a mobile phone. You should install this app in the Play Store 
UDPSender by hastarin 

The steps to test the program are as follows:
• Construct the circuit.
• Compile and download the program to your development board.
• Start the UDP Server apps on your mobile phone and set the Port number to 5000 and the
destination IP address (ESP-01 IP address, which was 192.168.1.160 in this project). 

Enter command ON1 followed by the Enter key (required for the scanf function) on the mobile
phone. Click Send to send the command to the development board. Relay 1 should now
become active and the red LED corresponding to this relay will turn ON

**********************************************************************/
#include "mbed.h"
//
// Define the expansion board to development board UART connections
//
#define TX PB_6//PA_9 // UART TX
#define RX PB_7//PA_10 // UART RX
//Serial esp(TX, RX); // UART TX,RX
Serial esp(PA_2,PA_3);
//Serial esp(PB_6,PB_7); // tx, rx
//
// Configure all relays as outputs and de-activate all relays
//
DigitalOut Relay1(PC_0, 1);
DigitalOut Relay2(PC_1, 1);
DigitalOut Relay3(PC_2, 1);
DigitalOut Relay4(PC_3, 1);
//
// This function connects to the Wi-Fi
//
void ConnectToWiFi()
{
    esp.printf("AT+RST\r\n");
    wait(2);

    esp.printf("AT+CWMODE=1\r\n");
    wait(3);

    esp.printf("AT+CWJAP=\"BTHomeSpot-XNH\",\"49346abaeb\"\r\n");
    wait(10);

    esp.printf("AT+CPIMUX=1\r\n");
    wait(3);

    esp.printf("AT+CIFSR\r\n");
    wait(3);

    esp.printf("AT+CIPSTART=\"UDP\",\"192.168.1.178\",0,5000,2\r\n");
    wait(3);
}
int main()
{
    char Buffer[80]; // Buffer to store data
    esp.baud(115200); // Set baud rate to 115200
    ConnectToWiFi(); // Connect to Wi-Fi
// Receive data packets over UDP and activate/de-activate the
// required relay. Function strstr(a,"b") returns a value greater than
// 0 if string a contains sub-string "b". The command sent by the
// mobile devuce must be terminated with an Enter key (required for
// the scanf function). Buffer is cleared at the beginning of the loop
//
    while(1) {
        for(int k = 0; k < 5; k++)Buffer[k] = 0;

        esp.scanf("%s",&Buffer);
        if(strstr(Buffer, "ON1") > 0) Relay1 = 0;
        else if(strstr(Buffer,"ON2") > 0) Relay2 = 0;
        else if(strstr(Buffer, "ON3")> 0) Relay3 = 0;
        else if(strstr(Buffer, "ON4") > 0) Relay4 = 0;
        else if(strstr(Buffer, "OFF1") > 0)Relay1 = 1;
        else if(strstr(Buffer, "OFF2") > 0)Relay2 = 1;
        else if(strstr(Buffer, "OFF3") > 0)Relay3 = 1;
        else if(strstr(Buffer, "OFF4") > 0)Relay4 = 1;
    }
}