#include "mbed.h"
#include "TextLCD.h"

Serial pc(PA_2,PA_3); // tx, rx
I2C i2c_lcd(PB_9, PB_8); // SDA, SCL
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD20x4);

/*
Para usar su LCD con el PCF8574 o el PCF8574A deben cambiar en la linea 73 del
archivo TextLCD_Config.h que esta en la libreria adjunta esto:
            #define DFROBOT        0
Por esto:
            #define DFROBOT        1

Pueden probar tambien estas otras opciones, me funciona bien casi para todas
excepto las que tienen un comentario con un //no

#define DEFAULT        0//no
#define ADAFRUIT       0//no
#define DFROBOT        0
#define LCM1602        0
#define YWROBOT        0
#define GYLCD          0//no
#define MJKDZ          0//no
#define SYDZ           1
#define WIDEHK         0//no
#define LCDPLUG        0//no
*/

//Para el ejemplo presente use #define SYDZ           1
//esto debe ir solo en el archivo mencionado


int main()
{
    Timer t;

    pc.printf("TextLCD Enhanced Test. Columns=%d, Rows=%d\n\r", lcd.columns(), lcd.rows());

    for (int row=0; row<lcd.rows(); row++) {
        int col=0;

        pc.printf("MemAddr(Col=%d, Row=%d)=0x%02X\n\r", col, row, lcd.getAddress(col, row));
//    lcd.putc('-');
        lcd.putc('0' + row);

        for (col=1; col<lcd.columns()-1; col++) {
            lcd.putc('*');
        }

        pc.printf("MemAddr(Col=%d, Row=%d)=0x%02X\n\r", col, row, lcd.getAddress(col, row));
        lcd.putc('+');
    }
    wait(1);
// Fill screen again and time it
    t.start();

    for (int row=0; row<lcd.rows(); row++) {
        int col=0;

        lcd.putc('0' + row);

        for (col=1; col<lcd.columns()-1; col++) {
            lcd.putc('*');
        }

        lcd.putc('+');
    }
    t.stop();
    pc.printf("All my hard work took %f sec\r\n", t.read());
    wait(1);


// Show cursor as blinking character
    lcd.setCursor(TextLCD::CurOff_BlkOn);

// Set and show user defined characters. A maximum of 8 UDCs are supported by the HD44780.
// They are defined by a 5x7 bitpattern.
    lcd.setUDC(0, (char *) udc_0);  // Show |>
    lcd.putc(0);
    lcd.setUDC(1, (char *) udc_1);  // Show <|
    lcd.putc(1);

    pc.printf("Bye now in original example \r\n");

    wait(1);


    /*****************************************************************************/
    pc.printf("From here is a new example for Master classes in UPS Guayaquil \r\n");

    // Clear the screen and locate to 0,0
    lcd.cls();

    // LCD Backlight control
    lcd.setBacklight(TextLCD::LightOn);

    // LCD Orientation control, supported for some Controllers
    //lcd.setOrient(TextLCD::Bottom);

    // LCD BigFont control, supported for some Controllers
    //lcd.LCDBigFont(TextLCD::TopBottomLine);

    // Locate cursor to a screen column and row
    int col = 0;
    int row = 0;
    lcd.locate(col,row);
    lcd.printf("Iniciando...");
    wait(1);

    //No Show cursor as blinking character
    lcd.setCursor(TextLCD::CurOff_BlkOff);

    // Write a character to the LCD "ARROW"
    int c = 1;
    lcd.cls();
    lcd.locate(0,0);
    for (int row=0; row<4; row++) {
        lcd.putc(c);
        wait(0.01);

        for (col=0; col<19; col++) {
            lcd.putc(c);
            wait(0.01);
        }
    }
    wait(2);

    // Write a raw string to the LCD
    const char* text = "Hola a todos!!";
    lcd.cls();
    lcd.locate(3,0);
    lcd.printf(text);
    wait(1);

    // Write a raw string to the LCD *-> pointer*

    lcd.locate(0,1);
    lcd.printf("/*----------------*/");

    const char* msg = "Mensaje con punteros";
    int string_size = strlen (msg);
    lcd.locate(0,2);
    lcd.printf("%.*s", string_size, msg);

    lcd.locate(0,3);
    const char* msg2 = "\"TXT: %.*s\",size,msg";
    int string_size2 = strlen (msg2);
    lcd.printf("%.*s", string_size2, msg2);
    wait(1);



    // Return the memoryaddress of screen column and row location
    lcd.getAddress(col,row);
    pc.printf("column %d\trow %d\r\n",col,row);
    wait(1);



    // Return the number of rows ans columns
    pc.printf("column %d\trow %d\r\n",lcd.rows(),lcd.columns());
    wait(1);



}



