/*
Exercise : Create a PWM signal which we can see on an
oscilloscope. The following code will generate a 100 Hz
pulse with 50% duty cycle
*/


#include "mbed.h"
PwmOut PWM1(p21);
int main()
{
    PWM1.period(0.010); // set PWM period to 10 ms
    PWM1=0.5; // set duty cycle to 50%
}

/*
Exercise : This example code uses a pulse width
modulation signal to increase and decrease
the brightness of the onboard LED
The program requires the use of a host terminal
application to communicate the
brightness value to the mbed, in this example by
using the ‘u’ and ‘d’ keys
*/



// host terminal LED dimmer control
#include "mbed.h"
Serial pc(USBTX, USBRX); // tx, rx
PwmOut led(LED1);
float brightness=0.0;
int main()
{
    pc.printf(“Control of LED dimmer by host terminal\n\r");
              pc.printf("Press 'u‘ = brighter, 'd‘ = dimmer\n\r");
    while(1) {
    char c = pc.getc();
        wait(0.001);
        if((c == 'u') && (brightness < 0.1)) {
            brightness += 0.001;
            led = brightness;
        }
        if((c == 'd') && (brightness > 0.0)) {
            brightness -= 0.001;
            led = brightness;
        }
        pc.printf("%c %1.3f \n \r",c,brightness);
    }
}

/*

Exercise 7: We are going to use the PWM to play the start of an
old English folk tune ‘Oranges and Lemons’. If you’re a reader of
music you will recognise this in the Figure below
• You just need to know that any note which is a minim lasts twice
as long as a crotchet, which in turn lasts twice as long as a quaver 

The following program implements the ‘Oranges and Lemons‘ musical
output
*/

// Oranges and Lemons program
#include "mbed.h"
PwmOut buzzer(p21);
float frequency[]= {659,554,659,554,550,494,554,587,494,659,554,440};
//frequency array
float beat[]= {1,1,1,1,1,0.5,0.5,1,1,1,1,2};
//beat array
int main()
{
    while (1) {
        for (int i=0; i<=11; i++) {
            buzzer.period(1/(frequency[i])); // set PWM period
            buzzer=0.5; // set duty cycle
            wait(0.5*beat[i]); // hold for beat period
        }
    }
}

