/*
A 7-segment display is actually just 8 LEDs in a single package. We can
therefore connect each LED pin to an mbed pin to display a chosen number.
*/


#include "mbed.h"
DigitalOut A(p5);
DigitalOut B(p6);
DigitalOut C(p7);
DigitalOut D(p8);
DigitalOut E(p9);
DigitalOut F(p10);
DigitalOut G(p11);
DigitalOut DP(p12);
int main()
{
    A=1;
    B=1;
    C=1;
    D=1;
    E=0;
    F=0;
    G=1;
    DP=0;
}


/*
*/
// program code for Exercise 2
#include "mbed.h"
BusOut Seg1(p5,p6,p7,p8,p9,p10,p11,p12); // ABCDEFGDP
int main()
{
    while (1) { // infinite loop
        Seg1=0x3F; // 00111111 binary LEDs to '0'
        wait(0.2);
        Seg1=0x06; // 00000110 binary LEDs to '1'
        wait(0.2);
        Seg1=0x5B; // 01011011 binary LEDs to '2'
        wait(0.2);
        Seg1=0x4F; // 01001111 binary LEDs to '3'
        wait(0.2);
        Seg1=0x66; // 01100110 binary LEDs to '4'
        wait(0.2);
        Seg1=0x6D; // 01101101 binary LEDs to '5'
        wait(0.2);
        Seg1=0x7D; // 01111101 binary LEDs to '6'
        wait(0.2);
        Seg1=0x07; // 00000111 binary LEDs to '7'
        wait(0.2);
        Seg1=0x7F; // 01111111 binary LEDs to '8'
        wait(0.2);
        Seg1=0x6F; // 01101111 binary LEDs to '9'
        wait(0.2);
    }
}




/*
FUNCTIONS
Return_type function_name (variable_type_1 variable_name_1, variable_type_2 variable_name_2,…)
{
... C code here
... C code here
}
char SegConvert(char SegValue) { // function 'SegConvert'
 char SegByte=0x00;
 switch (SegValue) { //DPGFEDCBA
 case 0 : SegByte = 0x3F;break; // 00111111 binary
 case 1 : SegByte = 0x06;break; // 00000110 binary
 case 2 : SegByte = 0x5B;break; // 01011011 binary
 case 3 : SegByte = 0x4F;break; // 01001111 binary
 case 4 : SegByte = 0x66;break; // 01100110 binary
 case 5 : SegByte = 0x6D;break; // 01101101 binary
 case 6 : SegByte = 0x7D;break; // 01111101 binary
 case 7 : SegByte = 0x07;break; // 00000111 binary
 case 8 : SegByte = 0x7F;break; // 01111111 binary
 case 9 : SegByte = 0x6F;break; // 01101111 binary
 }
 return SegByte;
}

*/


#include "mbed.h"
BusOut Seg1(p5,p6,p7,p8,p9,p10,p11,p12);// A,B,C,D,E,F,G,DP
char SegConvert(char SegValue); // function
prototype
int main()   // main program
{
    while (1) { // infinite loop
        for (char i=0; i<10; i++) {
            Seg1=SegConvert(i);
            wait(0.2);
        }
    }
}
char SegConvert(char SegValue)   // function 'SegConvert'
{
    char SegByte=0x00;
    switch (SegValue) { //DPGFEDCBA
        case 0 :
            SegByte = 0x3F;
            break; // 00111111 binary
        case 1 :
            SegByte = 0x06;
            break; // 00000110 binary
        case 2 :
            SegByte = 0x5B;
            break; // 01011011 binary
        case 3 :
            SegByte = 0x4F;
            break; // 01001111 binary
        case 4 :
            SegByte = 0x66;
            break; // 01100110 binary
        case 5 :
            SegByte = 0x6D;
            break; // 01101101 binary
        case 6 :
            SegByte = 0x7D;
            break; // 01111101 binary
        case 7 :
            SegByte = 0x07;
            break; // 00000111 binary
        case 8 :
            SegByte = 0x7F;
            break; // 01111111 binary
        case 9 :
            SegByte = 0x6F;
            break; // 01101111 binary
    }
    return SegByte;
}

/*
Reusing functions to reduce programming effort
*/

// main program code for Exercise 4
#include "mbed.h"
BusOut Seg1(p5,p6,p7,p8,p9,p10,p11,p12); // A,B,C,D,E,F,G,DP
BusOut Seg2(p13,p14,p15,p16,p17,p18,p19,p20);
char SegConvert(char SegValue); // function prototype
int main()   // main program
{
    while (1) { // infinite loop
        for (char j=0; j<10; j++) { // counter loop 1
            Seg2=SegConvert(j); // tens column
            for (char i=0; i<10; i++) { // counter loop 2
                Seg1=SegConvert(i); // units column
                wait(0.2);
            }
        }
    }
}
// SegConvert function here...


/*
Building complex mbed projects withfunctions
*/
void SegInit(void); // function to initialise 7-seg displays
void HostInit(void); // function to initialise the host terminal
char GetKeyInput(void); // function to get a keyboard input from the terminal
char SegConvert(char SegValue); // function to convert a number to a 7-segment byte

/*
Create a new project and add the following to your main.cpp file:
*/

#include "mbed.h"
Serial pc(USBTX, USBRX); // comms to host PC
BusOut Seg1(p5,p6,p7,p8,p9,p10,p11,p12); // A,B,C,D,E,F,G,DP
BusOut Seg2(p13,p14,p15,p16,p17,p18,p19,p20); // A,B,C,D,E,F,G,DP


void SegInit(void); // function prototype
void HostInit(void); // function prototype
Char GetKeyInput(void); // function prototype
char SegConvert(char SegValue); // function prototype
char data1, data2; // variable declarations


int main()   // main program
{
    SegInit(); // call function to initialise the 7-seg displays
    HostInit(); // call function to initialise the host terminal
    while (1) { // infinite loop
        data2 = GetKeyInput(); // call function to get 1st key press
        Seg2=SegConvert(data2); // call function to convert and output
        data1 = GetKeyInput(); // call function to get 2nd key press
        Seg1=SegConvert(data1); // call function to convert and output
        pc.printf(" "); // display spaces between 2 digit numbers
    }
}
// add function code here...

void SegInit(void)
{
    Seg1=SegConvert(0); // initialise to zero
    Seg2=SegConvert(0); // initialise to zero
}
void HostInit(void)
{
    pc.printf("\n\rType two digit numbers to be displayed on the 7-seg display\n\r");
}
char GetKeyInput(void)
{
    char c = pc.getc(); // get keyboard data (note numerical ascii range 0x30-0x39)
    pc.printf("%c",c); // print ascii value to host PC terminal
    return (c&0x0F); // return value as non-ascii (bitmask c with value 0x0F)
}
// copy SegConvert function here too...

/*
Creating a modular program
*/

// main.cpp file for Exercise 6
#include "mbed.h"
#include "HostIO.h"
#include "SegDisplay.h"
char data1, data2; // variable declarations
int main()   // main program
{
    SegInit(); // call function to initialise the 7-seg displays
    HostInit(); // call function to initialise the host terminal
    while (1) { // infinite loop
        data2 = GetKeyInput(); // call function to get 1st key press
        Seg2 = SegConvert(data2); // call function to convert and output
        data1 = GetKeyInput(); // call function to get 2nd key press
        Seg1 = SegConvert(data1); // call function to convert and output
        pc.printf(" "); // display spaces between 2 digit numbers
    }
}

// SegDisplay.cpp file for Exercise 6
#include "SegDisplay.h"
BusOut Seg1(p5,p6,p7,p8,p9,p10,p11,p12); // A,B,C,D,E,F,G,DP
BusOut Seg2(p13,p14,p15,p16,p17,p18,p19,p20); // A,B,C,D,E,F,G,DP
void SegInit(void)
{
    Seg1=SegConvert(0); // initialise to zero
    Seg2=SegConvert(0); // initialise to zero
}
char SegConvert(char SegValue)   // function 'SegConvert'
{
    char SegByte=0x00;
    switch (SegValue) { //DP G F E D C B A
        case 0 :
            SegByte = 0x3F;
            break; // 0 0 1 1 1 1 1 1 binary
        case 1 :
            SegByte = 0x06;
            break; // 0 0 0 0 0 1 1 0 binary
        case 2 :
            SegByte = 0x5B;
            break; // 0 1 0 1 1 0 1 1 binary
        case 3 :
            SegByte = 0x4F;
            break; // 0 1 0 0 1 1 1 1 binary
        case 4 :
            SegByte = 0x66;
            break; // 0 1 1 0 0 1 1 0 binary
        case 5 :
            SegByte = 0x6D;
            break; // 0 1 1 0 1 1 0 1 binary
        case 6 :
            SegByte = 0x7D;
            break; // 0 1 1 1 1 1 0 1 binary
        case 7 :
            SegByte = 0x07;
            break; // 0 0 0 0 0 1 1 1 binary
        case 8 :
            SegByte = 0x7F;
            break; // 0 1 1 1 1 1 1 1 binary
        case 9 :
            SegByte = 0x6F;
            break; // 0 1 1 0 1 1 1 1 binary
    }
    return SegByte;
}

/*
SegDisplay.h should be as follows:
*/

// SegDisplay.h file for Exercise 6
#ifndef SEGDISPLAY_H
#define SEGDISPLAY_H
#include "mbed.h"
extern BusOut Seg1; // allow Seg1 to be manipulated by other files
extern BusOut Seg2; // allow Seg2 to be manipulated by other files
void SegInit(void); // function prototype
char SegConvert(char SegValue); // function prototype
#endif

/*
The HostIO.cpp should therefore be as follows:
*/

#include "HostIO.h"
#include "SegDisplay.h" // allow access to functions and objects in SegDisplay.cpp
Serial pc(USBTX, USBRX); // communication to host PC
void HostInit(void) {
 pc.printf("\n\rType two digit numbers to be displayed on the 7-seg display\n\r");
}
char GetKeyInput(void) {
 char c = pc.getc(); // get keyboard data (note numerical ascii range 0x30-0x39)
 pc.printf("%c",c); // print ascii value to host PC terminal
 return (c&0x0F); // return value as non-ascii (bitmask c with value 0x0F)
}

/*
HostIO.h should be as follows:
*/
#ifndef HOSTIO_H
#define HOSTIO_H
#include "mbed.h"
extern Serial pc; // allow pc to be manipulated by other files
void HostInit(void); // function prototype
char GetKeyInput(void); // function prototype
#endif

