#include "mbed.h"

RawSerial pc(PA_2,PA_3);
RawSerial dev(PB_6,PB_7); // tx, rx// tx, rx
DigitalOut  led1(PD_12);      // (PTB18)
DigitalOut  led2(PD_13);    // (PTB19)
DigitalOut  led4(PD_14);     // (PTD1)

/*

Connecting...
Chip is ESP8266EX
Features: WiFi
Crystal is 26MHz
MAC: 18:fe:34:d7:a3:da


*/
void dev_recv()
{
    led1 = !led1;
    while(dev.readable()) {
        pc.putc(dev.getc());
    }
}

void pc_recv()
{
    led4 = !led4;
    while(pc.readable()) {
        dev.putc(pc.getc());
    }
}

int main()
{
    pc.baud(115200);
    dev.baud(115200);

    pc.attach(&pc_recv, Serial::RxIrq);
    dev.attach(&dev_recv, Serial::RxIrq);

    while(1) {
        sleep();
    }
}
