#include<mbed.h>
#include<vector>
#include"Servo.h"

Servo::Servo(PwmOut& _servo,float _minwidth,float _maxwidth,float _maxspeed)
:servo_pwm(_servo),min_pulsewidth_us(_minwidth),max_pulsewidth_us(_maxwidth),operatingspeed(_maxspeed)
{
    Servo_Move_Absolute(0);
    nowdig=0;
}

float Servo::dig_to_pulse(float dig)
{
    return (float)(max_pulsewidth_us-min_pulsewidth_us)*dig/180+min_pulsewidth_us;
}

float Servo::pulse_to_dig(float pulse)
{
    return (float)(pulse-min_pulsewidth_us)*180/(max_pulsewidth_us-min_pulsewidth_us);
}

void Servo::Servo_Move_Absolute(float dig)
{
    servo_pwm.period_ms(20);
    servo_pwm.pulsewidth_us(dig_to_pulse(dig));
    nowdig = dig;
}

void Servo::Servo_Move_Absolute(float dig,float speed)
{
    printf("start moving\n");
    if(dig<nowdig&&speed>0)
    {
        speed*=-1;
    }else if(dig>nowdig&&speed<0)
    {
        speed*=-1;
    }
    if(speed>operatingspeed)
    {
        speed=operatingspeed;
    }else if(speed<-operatingspeed)
    {
        speed=-1*operatingspeed;
    }
    servo_pwm.period_ms(20);
    float cnt = 0;
    while(1)
    {
        nowdig+=speed;
        servo_pwm.pulsewidth_us(dig_to_pulse(nowdig));
        printf("%f\n",(float)nowdig);
        wait_us(100000);
        if(-2<nowdig-dig&&nowdig-dig<2)
        {
            break;
        }
        cnt+=1;
    }
}

void Servo::Servo_Move_Relative(float dig)
{
    Servo_Move_Absolute(nowdig+dig);
}

void Servo::Servo_Move_Relative(float dig,float speed)
{
    Servo_Move_Absolute(nowdig+dig,speed);
}