#include "common.h"
#include "RTCtime.h"
#include "Queue.h"
#include "Atmel.h"
#include "Command.h"
#include "Statistics.h"


// Run time Statistics
statistics Statistics;

// LED definitions
DigitalOut RedCathode(PTB18);
DigitalOut GreenCathode(PTB19);
DigitalOut BlueCathode(PTB1);

int ShowRTClockMinutes = 0; //When = 1, display time at 1 minute marks.
int InteractiveMode = 0; // Silent, or display entered command characters for human
// Atmel ~Reset line
DigitalOut AtmelReset(PTC10);
Serial pc (USBTX, USBRX);  // Serial connection

// Atmel ~Change discrete
DigitalIn enable(PTC11);

I2C i2c(PTB1, PTB0);


void ms_ticker(void)
{
    Statistics.IncrementRunTime_ms();
}


// Clock task. Call at .01 second intervals
void RTclock(void)
{
    clock_service();
}

// Task definitions
Ticker RTClockTick;
Ticker AtmelReadFrame;
Ticker LEDTimer;
Ticker MS;

uint8 ActivityIndicator = 0;
uint8 CycleTestFixtureFault = 0;

LEDcolor_t LEDcolor;

// Send Identity CSV out on USB
void WhoAmI(void)
{
    pc.printf("STATUS, CycleTestFixture, Version=%s, MPUdeviceID=%08X%08X%08X\n",
              SWversion,
              SIM->UIDMH,
              SIM->UIDML,
              SIM->UIDL);
}
void LEDcontrol(LEDcolor_t Led_color, int OFFon)
{
    switch (LEDcolor) {
        case lRed:
            RedCathode = OFFon;
            break;
        case lGreen:
            GreenCathode = OFFon;
            break;
        case lBlue:
            BlueCathode = OFFon;
            break;
    }
}
uint8 LEDblink=0;
void LED(void)
{
    if (LEDblink)
        LEDblink--;
    else {
        if(CycleTestFixtureFault) {
            LEDcolor = lRed;
            RedCathode = LED_ON;
        } else {
            if (ActivityIndicator) {
                LEDblink = 1;
                LEDcontrol(LEDcolor, LED_OFF);
            } else
                LEDcontrol(LEDcolor, LED_ON);
        }
    }
}

Synchronize GuardCriticalSection;
AtmelEventType AtmelEvent;

int main()
{

    extern Queue AtmelMessageQueue;

    AtmelHumanReadMode = 0;
    ActivityIndicator =0;

    RedCathode = LED_OFF;
    GreenCathode = LED_OFF;
    BlueCathode = LED_OFF;

    LEDcolor = lBlue;
    LEDcontrol(LEDcolor, LED_ON);

    AtmelSetAddress(0x4B);

// Start the periodic tasks.
    RTClockTick.attach_us(RTclock,10000);
    MS.attach_us(ms_ticker,1000);
    LEDTimer.attach_us(LED,100000);
    AtmelReadFrame.attach_us(AtmelReadEvents,100000);

//Start with a hard reset, followed by two Atmel status messages (FingerID = 0x01)
    if(AtmelDeviceReset()) {
        WhoAmI();
        // Start the read frame, since we have working hardware
//        AtmelReadFrame.attach_us(AtmelReadEvents,100000);
    } else {
        LEDcolor = lRed;
        CycleTestFixtureFault = 1;
        pc.printf("STATUS, **Touch Controller Failure**, MPUdeviceID=%08X%08X%08X\n",SIM->UIDMH,SIM->UIDML,SIM->UIDL);
        while(1); //Hang. Can't do anything with no Atmel
    }

// Main loop. Get USB commands from host and process. Check message queue from touch screen
// controller and transmit back over USB to host.
    LEDcolor = lGreen;
    while (1) {
        GetSerialCommand(&pc);
        ProcessSerialCommands(&pc);

        if (GuardCriticalSection.EnterSlave()) {
            while (AtmelMessageQueue.Get(&AtmelEvent,sizeof(AtmelEventType))) {
                AtmelSendStatus (&pc, &AtmelEvent);
            }
            GuardCriticalSection.ExitSlave();
        }
    }
}





