#ifndef _Common
#define _Common

#include "mbed.h"
#include "Synchronize.h"
#include "Statistics.h"

#define SWversion "1.0"

// Remember, it's an LED.  GROUND the cathode to turn it on
#define LED_ON 0  
#define LED_OFF 1


typedef unsigned int uint32;
typedef unsigned short uint16;
typedef unsigned char uint8;
typedef unsigned char UCHAR;
typedef enum {lRed, lGreen, lBlue} LEDcolor_t;

extern statistics Statistics;

extern Serial pc;  // Serial connection
extern DigitalOut AtmelReset;
extern DigitalIn enable;
extern I2C i2c;

extern int ShowRTClockMinutes;
extern int InteractiveMode;
extern uint8 ActivityIndicator;
extern uint8 CycleTestFixtureFault;
extern LEDcolor_t LEDcolor;

extern Synchronize GuardCriticalSection;

void Delay_ms(int milliseconds);
void WhoAmI(void);


#endif





