#include "Synchronize.h"

Synchronize::Synchronize()
{    OK_master_entry = 1;
     OK_slave_entry = 0;
     SlaveRequest = 0;
     SlaveHasControl = 0;
     MasterHasControl = 0;
     GrantSlaveRequest = 0;
     SlaveExitRequest = 0;
}
Synchronize::~Synchronize(){}


int Synchronize::EnterMaster(void)
{
    if (SlaveHasControl)
        OK_master_entry =0;
    else {
        if (SlaveRequest) {
            GrantSlaveRequest = 1;
            SlaveRequest = 0;
        }
        if(SlaveExitRequest)
        {
            SlaveExitRequest =0;
            OK_master_entry =1;
            }
    }

    return OK_master_entry;
}

void Synchronize::ExitMaster(void)
{
    if (GrantSlaveRequest) {
        SlaveHasControl =1;
        GrantSlaveRequest =0;
        MasterHasControl = 0;
    }
}

int Synchronize::EnterSlave(void)
{
    if (SlaveHasControl) {
        OK_slave_entry =1;
    } else {
        OK_slave_entry =0;
        SlaveRequest = 1;
    }
    return OK_slave_entry;
}
void Synchronize::ExitSlave(void)
{
    SlaveExitRequest = 1;
    SlaveHasControl = 0;
}