
#include "common.h"
#include "RTCtime.h"
#include "Statistics.h"

/**  rtc_init
 * \brief    Initialize RTC module to count seconds
 * \author
 * \param none
 * \return none
 */




time_date_t SystemTime= {0,0,0,15,0,14,10,1066}; // initialize to the battle of Hastings (about the time things went really, really wrong.)

char * month_names[] = {"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
char * day_names[] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};

char * DisplayTimeDate(void)
{
    static char TimeAndDate[64];
        time_date_t  CurrentTime;
    GetRTclock(&CurrentTime);


    sprintf (TimeAndDate,"STATUS,%08X%08X%08X,%02d/%02d/%04d,%02d:%02d:%02d.%02d",
             SIM->UIDMH, // 96 bit Unique ID
             SIM->UIDML, 
             SIM->UIDL,    
             CurrentTime.month, // Date 
             CurrentTime.day, 
             CurrentTime.year,
             CurrentTime.hours,  // Time
             CurrentTime.minutes, 
             CurrentTime.seconds, 
             CurrentTime.hundredths);
        
    return TimeAndDate;
}

void set_time(time_date_t * td, char hr, char min, char sec)
{
    td->hours   = hr;
    td->minutes = min;
    td->seconds = sec;
}


/**/
void set_date(time_date_t * td, char day, char month, int year)
{
    td->day   = day;
    td->month = month;
    td->year = year;
}

/* day number between 1-7*/
void set_daynumber(time_date_t * td, char weekday)
{
    td->weekday   = weekday;
}


#define YEAR_BASE 2012

/* YEArS */
typedef struct {
    uint16 daysPerYear;
    uint16 ElapseddaysPerYear;
} str_daysPerYear;

typedef struct {
    uint8    daysPerMonth;
    uint16   elapsedDays;
    uint8    bisdaysPerMonth;
    uint16   biselapsedDays;
} str_day_per_month;


const  str_daysPerYear YEAR_ELAPSED_DAY[] = {
    //Days per year,  elapsedYears
    366, 366 ,  //2012
    365, 731 ,  //2013
    365, 1096 ,  //2014
    365, 1461 ,  //2015
    366, 1827 ,  //2016
    365, 2192 ,  //2017
    365, 2557 ,  //2018
    365, 2922 ,  //2019
    366, 3288 ,  //2020
    365, 3653 ,  //2021
    365, 4018 ,  //2022
};




const str_day_per_month  DAYS_PER_MONTH[] = {
//DaysPerMonth,ElapDays,BisDaysPerMonth,BisElapDays
    31,  31,31,  31,  //"offset31
    28,  59,29,  60,  //"offset29
    31,  90,31,  91,  //"offset31
    30,  120,30,  121,  //"offset30
    31,  151,31,  152,  //"offset31
    30,  181,30,  182,  //"offset30
    31,  212,31,  213,  //"offset31
    31,  243,31,  244,  //"offset31
    30,  273,30,  274,  //"offset30
    31,  304,31,  305,  //"offset31
    30,  334,30,  335,  //"offset30
    31,  365,31,  366,  //"offset31
};


void seconds_to_date(uint32 elapsed_seconds)
{
    uint32 elapsed_days;
    uint32 remaining_sec;
    uint32 elapsed_hours;
    uint32 elapsed_min;
    uint8  off_year;
    uint8  off_month;

    uint8  bisiesto;
    uint16 year;
    uint16 daysofyear;
    uint16 dayofmonth;

    elapsed_days  = elapsed_seconds/(60*60*24);
    remaining_sec = elapsed_seconds%(60*60*24);

    elapsed_hours = remaining_sec/(60*60);
    remaining_sec = elapsed_seconds%(60*60);

    elapsed_min = remaining_sec/(60);
    elapsed_seconds = elapsed_seconds%(60);

    //search for year
    off_year=0;
    while(elapsed_days>YEAR_ELAPSED_DAY[off_year].ElapseddaysPerYear) off_year++;
    year = YEAR_BASE + off_year;
    bisiesto = !(YEAR_ELAPSED_DAY[off_year].daysPerYear & 0x1);

    //search for month and day of the month
    daysofyear = elapsed_days - YEAR_ELAPSED_DAY[off_year].daysPerYear;

    if (bisiesto) {
        off_month = 0;
        while (daysofyear > DAYS_PER_MONTH[off_month].biselapsedDays)off_month++;
        dayofmonth = daysofyear;
        if (off_month>0) dayofmonth = daysofyear - DAYS_PER_MONTH[off_month].biselapsedDays;
    } else {
        off_month = 0;
        while (daysofyear > DAYS_PER_MONTH[off_month].elapsedDays)off_month++;
        dayofmonth = daysofyear;
        if (off_month>0) dayofmonth = daysofyear - DAYS_PER_MONTH[off_month].elapsedDays;
    }

    set_time(&SystemTime, elapsed_hours, elapsed_min, elapsed_seconds);
    set_date(&SystemTime, year, off_month+1, dayofmonth);
}

uint32 date_to_seconds(time_date_t * td)
{

    char bisiesto;
    char off_year;
    uint16 dayofyear;
    uint32 elapsed_seconds=0;
    uint32 elapsed_days=0;


    off_year = td->year - YEAR_BASE;
    bisiesto = !(YEAR_ELAPSED_DAY[off_year].daysPerYear & 0x1);

    if (off_year>0)
        elapsed_days = YEAR_ELAPSED_DAY[off_year-1].ElapseddaysPerYear;


    if (bisiesto) {
        dayofyear = DAYS_PER_MONTH[td->month-1].biselapsedDays;
        dayofyear += td->day;
    } else {
        dayofyear = DAYS_PER_MONTH[td->month-1].biselapsedDays;
        dayofyear += td->day;
    }

    elapsed_days += dayofyear;

    elapsed_seconds = elapsed_days*(60*60*24) + td->hours*60*60 + td->minutes*60 + td->seconds;
    return elapsed_seconds;

}

int displaytime = 0;
/* This function must be called every 100th of a second*/
void clock_service(void)
{
    time_date_t * td = &SystemTime;
    if (++td->hundredths > 99 ) {
        td->hundredths =0;
        if (++td->seconds >59 ) {
            displaytime = ShowRTClockMinutes; // Display time at the minute mark
            td->seconds =  0;
            if (++td->minutes >59 ) {
                td->minutes =  0;
                if (++td->hours >23 ) {
                    td->hours = 0;
                    if (++td->weekday >7 ) {
                        td->weekday =1;
                    }
                    td->day++;
                    if (td->month==2) {
                        if ((td -> year%4)  == 0) {
                            if  (td->day > 29)      td->day = 1;
                        } else  if (td->day > 28) td->day = 1;
                    } else if (td->month==4 || td->month==6 || td->month==9  ||   td->month==11) {
                        if (td->day  > 30) td->day = 1;
                    } else { // if (td->month==1 || td->month==3 || td->month==5 ||  td->month==7 || td->month==8  ||   td->month==10     ||  td->month==12)
                        if (td->day > 31) td->day = 1;
                    }
                    if ( td->hours == 0 && td->day==1) {
                        if (++td->month > 12) {
                            td->month = 1;
                            td->year++;
                        } //year
                    }//month
                }//hour
            }//minutes
        }//seconds
    }//hundredths
    if(displaytime)
        pc.printf ("\n<%s>\n",DisplayTimeDate());
    displaytime = 0;
}




int GetRTclock(time_date_t * time)
{
    memmove(time,&SystemTime,sizeof(time_date_t));
    return 0;
}


void set_RTClock_time(char hr, char min, char sec, char hun)
{
    time_date_t * td = &SystemTime;
    td->hours   = hr;
    td->minutes = min;
    td->seconds = sec;
    td->hundredths = hun;
}


/**/
void set_RTClock_date(char day, char month, int year)
{
    time_date_t * td = &SystemTime;
    td->day   = day;
    td->month = month;
    td->year = year;
}





