#include "common.h"
#include "Queue.h"
extern Serial pc;

// Implement FIFO queue for generic object.  Must supply size with object to help
// allocate memory.  On Get(), also need size because this will memmove() the 
// 'size' amount of bytes back to caller. Make sure target buffer is sized right!

Queue::~Queue()
{
    CleanQueue();
}
Queue::Queue()
{
    Head = 0;
    Tail = 0;
    EntryCount = 0;
}

int Queue::NumberEntries(void)
{
    return EntryCount;
}

void Queue::CleanQueue(void)
{
    QueueEntry * Temp;
    EntryCount = 0;
    while (Head) {
        Temp = Head->Next;
        DestroyEntry(Head);
        Head = Temp;
    }
}

void Queue::DestroyEntry(QueueEntry * entry)
{
    delete entry->Qpayload;
    delete entry;
}

Queue::QueueEntry * Queue::MakeEntry(void * Payload, int size)
{
// Was using C++ 'new' operator. Switched to malloc to try and detect out=of-memory
// null return, but it doesn't seem to.  Look in Put() method for arbitrary 'Queue
// full' at about 130 entries.

//    next = new QueueEntry;
    next = (QueueEntry*)malloc(sizeof(QueueEntry));
    if(next) {
        next->Next = 0;
        next->Previous = 0;
        next->QpayloadSize = size;
        EntryCount++;
        next->Qpayload = new unsigned char[size];        ;
        memmove(next->Qpayload, Payload, size);
    }
    return next;
}
int Queue::Get(void * Payload, int size)
{

    QueueEntry * Temp;
    if (!Head) // Queue Empty
        return 0;
    else {
        Temp = Head;
        memmove(Payload, Head->Qpayload, Head->QpayloadSize);
        Head = Head->Next;
        if (!Head)
            Tail = 0;
        DestroyEntry(Temp);
        EntryCount--;
        return 1;
    }

}
void Queue::Put(void * Payload, int size)
{
    // Looks like we run out of heap at about 140. Plus, we're competing with stdio for 
    // memory, so declaring the queue full here should keep us from hanging.
    if(EntryCount >= 130) {
        pc.printf("** Queue is Full! **\n");
    } else if (MakeEntry(Payload, size)) {

        if (Tail) {
            Tail->Next = next;  // Add to end of Queue
            next->Previous = Tail;
            Tail = next;
        } else { // First entry in queue
            Head = Tail = next;
        }
    } else {
        pc.printf("Queue Full!\n");
    }
}

