#include "Command.h"
#include "RTCtime.h"
#include "Atmel.h"

void DisplayHumanStatistics(Serial *PC)
{
    PC->printf("");
}

void DisplayReportStatistics(Serial *PC)
{
    PC->printf("STATUS,");
    PC->printf("MPUdeviceID=%08X%08X%08X,",
               SIM->UIDMH,
               SIM->UIDML,
               SIM->UIDL);
    PC->printf("%0.1f,",(float)Statistics.GetRunTime_ms() / 1000.0);
    PC->printf("%d,",Statistics.GetEvent());
    PC->printf("%d,",Statistics.GetDetect());
    PC->printf("%d,",Statistics.GetPress());
    PC->printf("%d,",Statistics.GetRelease());
    PC->printf("%d,",Statistics.GetMove());
    PC->printf("%d,",Statistics.GetVector());
    PC->printf("%d,",Statistics.GetAmp());
    PC->printf("%d,",Statistics.GetSuppress());
    PC->printf("%d",Statistics.GetReserved());
    PC->printf("\n");
}

void ProcessStatisticsCommand(Serial *PC)
{
    if (AtmelHumanReadMode)
        DisplayHumanStatistics(PC);
    else
        DisplayReportStatistics(PC);

    ActivityIndicator = 0;
}

Queue CommandQueue;
// Single character case-sensitive commands with optional parameeters.  Command terminated by a colon
// unless no parameters.  Parameters separated by commas.  See 'H' command for list of commands.
int Process_UART_Command(Serial * PC, char * Command)
{
    char * ParseBuffer;
    char * CommandCode;
    char Code;

    char * Hour;
    int hour;
    char * Minute;
    int minute;
    char * Second;
    int second;

    char * Month;
    int month;
    char * Day;
    int day;
    char * Year;
    int year;
    char * ModeFlag;
    int modeflag;
    time_date_t  time;


    if (strlen(Command) <= 0)
        return -1;
    else {
        strcat(Command,"^");
        CommandCode =  strtok_r(Command,":^", &ParseBuffer);  //Add carat at end to help strtok parse partial command
        Code = CommandCode[0];

        switch (Code) {
            case 'T':
                GetRTclock(&time);

                Hour = strtok_r(NULL,",^", &ParseBuffer);
                if (Hour)
                    sscanf(Hour,"%d",&hour);
                else
                    return -1;// Fail, at least one field should be set

                Minute = strtok_r(NULL,",^", &ParseBuffer);
                if (Minute) {
                    sscanf(Minute,"%d",&minute);
                    Second = strtok_r(NULL,",^", &ParseBuffer);
                    if (Second)
                        sscanf(Second,"%d",&second);
                    else
                        second = time.seconds;
                } else
                    minute = time.minutes;


                set_RTClock_time(hour, minute, second,0);// Set new time, hundredths = 0
                if (InteractiveMode)
                    PC->printf("%s\n",DisplayTimeDate());
                break;
            case 'D':  // MM,DD,YYY -- All three fields must be supplied
                Month = strtok_r(NULL,",^", &ParseBuffer);
                if (Month) {
                    sscanf(Month,"%d",&month);
                    Day =  strtok_r(NULL,",^", &ParseBuffer);
                    if(Day) {
                        sscanf(Day,"%d",&day);
                        Year = strtok_r(NULL,",^", &ParseBuffer);
                        if (Year)
                            sscanf(Year,"%d",&year);
                        else
                            return -1;
                    } else
                        return -1;
                } else
                    return -1;
                set_RTClock_date(day, month, year);
                if (InteractiveMode)
                    PC->printf("%s\n",DisplayTimeDate());
                break;
            case 'M':
                ModeFlag = strtok_r(NULL,",", &ParseBuffer);
                sscanf(ModeFlag,"%d",&modeflag);
                if (modeflag)
                    AtmelHumanReadMode = 1;
                else
                    AtmelHumanReadMode = 0;
                break;
            case 'A':
                ModeFlag = strtok_r(NULL,",", &ParseBuffer);
                sscanf(ModeFlag,"%d",&modeflag);
                if (modeflag)
                    ShowRTClockMinutes = 1;
                else
                    ShowRTClockMinutes = 0;
                break;
            case 'I':
                ModeFlag = strtok_r(NULL,",", &ParseBuffer);
                sscanf(ModeFlag,"%d",&modeflag);
                if (modeflag)
                    InteractiveMode = 1;
                else
                    InteractiveMode = 0;
                break;
            case 'R':
                ModeFlag = strtok_r(NULL,",^", &ParseBuffer);
                modeflag = 0;
                sscanf(ModeFlag,"%d",&modeflag);
                if(modeflag) {
                    AtmelDeviceReset();
                    WhoAmI();
                }

                break;
            case 'S':
                ModeFlag = strtok_r(NULL,",^", &ParseBuffer);
                modeflag = 0;
                sscanf(ModeFlag,"%d",&modeflag);
                if(modeflag) {
                    ProcessStatisticsCommand(&pc);
                }

                break;
            case 'H':
                WhoAmI();
                pc.printf("\nCycle Test Fixture host commands:\n");
                pc.printf("A:n             -- Display time ticks. n=1: Show time at minute mark; n=0: Silent (default)\n");
                pc.printf("D:MM,DD,YYY     -- Set current date. Month, day, year required\n");
                pc.printf("H               -- Display this command help message\n");
                pc.printf("I:n             -- Display command feedback. n=1: Show text entry, status; n=0: Silent (default)\n");
                pc.printf("M:n             -- Set report mode. n=1: Human Readable; n=0: CSV (default)\n");
                pc.printf("R:n             -- Issue Atmel hardware reset. n=1: Issue reset. n !=1: do nothing.\n");
                pc.printf("S:n             -- Display accumulated statistics. n=1: Display Statistiscs CSV. n !=1: do nothing.\n");
                pc.printf("T:HH{,MM,SS}    -- Set current time. Hour required, minutes, seconds optional.  Unspecified units remain unchanged.\n");
                pc.printf("W               -- Who are you? Replies with CSV: SW name, Version, MPU Unique Device ID (96 bits, Hex).\n");
                break;
            case 'W':
                WhoAmI();
                break;
            default:
                break;
        }
    }
    LEDcolor = lGreen;
    ActivityIndicator = 0;
    return 1;
}


void ProcessSerialCommands(Serial * pc)
{
    char CommandBuffer[CommandBufferSize];

    while (CommandQueue.Get(CommandBuffer, sizeof(CommandBuffer))) {
        Process_UART_Command(pc,CommandBuffer);

    }
}


// Concatenate characters as they come in over USB.  Stop scan when \r detected and send to queue.
// Stop adding characters when buffer size reached (remember the trailing '\0')
char * GetSerialCommand(Serial * pc)
{
    static char CommandBuffer[CommandBufferSize]= {'\0'}; //Initialize to NULL string
    static char * current= CommandBuffer;
    char c;

    if (pc->readable()) {
        c=pc->getc();
        if (c == '\r') {
            if (InteractiveMode)
                pc->putc('\n');
            LEDcolor = lBlue;
            ActivityIndicator = 1;
            CommandQueue.Put(CommandBuffer, strlen(CommandBuffer)+1); // Size of command + 1 for zero byte at end
            current = CommandBuffer; // reset cursor to beginning
        } else if (((current-CommandBuffer)) >= sizeof(CommandBuffer)-1) {
            if (InteractiveMode)
                pc->putc('\07');// Input excedes buffer size. Audible bell for interactive user
        } else {
            if (InteractiveMode)
                pc->putc(c);
            *current++ = c;
            *current = '\0';
        }
    }

    return CommandBuffer;
}
