#include "RTCtime.h"

#define AtmelStatusDetect    0x80
#define AtmelStatusPress     0x40
#define AtmelStatusRelease   0x20
#define AtmelStatusMove      0x10
#define AtmelStatusVector    0x08
#define AtmelStatusAmplitude 0x04
#define AtmelStatusSuppress  0x02
#define Boolean(B) (B ? "True" : "False")

extern int AtmelHumanReadMode;

typedef struct {
    short int FingerID;
    short int X;
    short int Y;
    UCHAR TouchArea;
    UCHAR TouchAmplitude;
    UCHAR Detect;
    UCHAR Press;
    UCHAR Release;
    UCHAR Move;
    UCHAR Vector;
    UCHAR Amp;
    UCHAR Suppress;
} AtmelStatus;


typedef struct {
    long EventNumber;
    uint8 EventData[8];
    time_date_t EventTime;
} AtmelEventType;

void AtmelSendStatus (Serial * PC, AtmelEventType * AtmelEvent);
void AtmelHardwareReset(void);

void AtmelReadEvents(void);
void AtmelReadEvent(AtmelEventType * EventRecord);

void AtmelSetAddress(int I2Caddress);
int AtmelDeviceReset(void);
void AtmelDoRead(void);
