#include "mbed.h"
#include "LTC2991.h" 
#include <stdarg.h>

int8_t ack; // 0 == ack, 1 == no ack
const uint16_t LTC2991_TIMEOUT=1000; //!< Configures the maximum timeout allowed for an LTC2991 read.
Serial pc(USBTX, USBRX, 9600);

//These pins for the nucleo nucleo f401re
//LTC2991 *ltc0 = new LTC2991(I2C_SDA, I2C_SCL);
//LTC2991 *ltc1 = new LTC2991(PB_3, PB_10);
LTC2991 *ltc2 = new LTC2991(PB_4, PA_8);


//void setup();
int main();
void readSingle();
void readDiff();
void setup() {
  //init lib
  
  
  ack = 0;
  while (true)
  {
    pc.printf("boot\n");
    ack |= ltc2->LTC2991_register_write(LTC2991_I2C_ADDRESS, LTC2991_CHANNEL_ENABLE_REG, LTC2991_ENABLE_ALL_CHANNELS); //! Enables all channels
    ack |= ltc2->LTC2991_register_write(LTC2991_I2C_ADDRESS, LTC2991_CONTROL_V1234_REG, 0x00); //! Sets registers to default starting values.
    ack |= ltc2->LTC2991_register_write(LTC2991_I2C_ADDRESS, LTC2991_CONTROL_V5678_REG, 0x00);
    ack |= ltc2->LTC2991_register_write(LTC2991_I2C_ADDRESS, LTC2991_CONTROL_PWM_Tinternal_REG, LTC2991_REPEAT_MODE); //! Configures LTC2991 for Repeated Acquisition mode
    
    if (ack != 0) {
      pc.printf("Error: No Acknowledge. Check I2C Address.\n");
      wait_ms(500);
    } else {
      break;
    }
  }
}

int main() {
    setup();
    while(1) {
        readDiff();
        readSingle();
        wait_ms(750);
    }
}

void readSingle() {
  int8_t data_valid;
  int16_t code;
  float voltage;
  ack = 0;
  ack |= ltc2->LTC2991_register_set_clear_bits(LTC2991_I2C_ADDRESS, LTC2991_CONTROL_V1234_REG, 0x00, LTC2991_V1_V2_DIFFERENTIAL_ENABLE | LTC2991_V1_V2_TEMP_ENABLE);
  ack |= ltc2->LTC2991_adc_read_new_data(LTC2991_I2C_ADDRESS, LTC2991_V1_MSB_REG, &code, &data_valid, LTC2991_TIMEOUT);
  voltage = ltc2->LTC2991_code_to_single_ended_voltage(code, LTC2991_SINGLE_ENDED_lsb);
  if (ack != 0) {
      pc.printf("Error: No Acknowledge.\n");
  } else {
      pc.printf("V1: %4.2f V\n", voltage);
  }
}

void readDiff() {
  int8_t data_valid;
  int16_t code;
  float voltage;
  ack = 0;
  ack |= ltc2->LTC2991_register_set_clear_bits(LTC2991_I2C_ADDRESS, LTC2991_CONTROL_V1234_REG, LTC2991_V1_V2_DIFFERENTIAL_ENABLE, LTC2991_V1_V2_TEMP_ENABLE);
  ack |= ltc2->LTC2991_adc_read_new_data(LTC2991_I2C_ADDRESS, LTC2991_V2_MSB_REG, &code, &data_valid, LTC2991_TIMEOUT);
  voltage = ltc2->LTC2991_code_to_differential_voltage(code, LTC2991_DIFFERENTIAL_lsb);
  if (ack != 0) {
      pc.printf("Error: No Acknowledge.\n");
  } else {
      pc.printf("V1-V2: %4.2f V\n", voltage, ack);
  }
}