#include "SerialTerminal.h"

#include "mbed.h"

SerialTerminal::SerialTerminal(PinName tx, PinName rx, int Baudrate) : Serial(tx, rx) 
{
     this->baud(Baudrate);
}

void SerialTerminal::cls() {
    this->printf("\033[2J");
}

void SerialTerminal::locate(int column, int row) {
    // Cursor Home    <ESC>[{ROW};{COLUMN}H
    this->printf("\033[%d;%dH%c", row + 1, column + 1);
}

static int rgb888tobgr111(int colour) {
    int r = (colour >> 23) & 1;
    int g = (colour >> 15) & 1;
    int b = (colour >> 7) & 1;
    return (b << 2) | (g << 1) | (r << 0);
}

void SerialTerminal::foreground(int colour) {
    // Set Attribute Mode    <ESC>[{n}m
    // Foreground Colours : 30 + bgr
    int c = 30 + rgb888tobgr111(colour);
    this->printf("\033[%dm", c);
}

void SerialTerminal::background(int colour) {
    // Set Attribute Mode    <ESC>[{n}m
    // Background Colours : 40 + bgr
    int c = 40 + rgb888tobgr111(colour);
    this->printf("\033[%dm", c);
}

void SerialTerminal::hideCursor() {
    //Hide cursor from terminal
    this->printf("\033[?25l");    
}

void SerialTerminal::showCursor() {
    //Hide cursor from terminal
    this->printf("\33[[?25h");    
}

void SerialTerminal::move_cursor_up(int step_num) {
    this->printf("\033[%dA", step_num);
}
    
void SerialTerminal::move_cursor_down(int step_num) {
    this->printf("\033[%dB", step_num);
}
    
void SerialTerminal::move_cursor_right(int step_num) {
    this->printf("\033[%dC", step_num);
}
    
void SerialTerminal::move_cursor_left(int step_num) {
    this->printf("\033[%dD", step_num);
}

void SerialTerminal::hide_cursor() {
    this->printf("\e[?25l");
}
    
void SerialTerminal::show_cursor() {
    this->printf("\e[?25h");
}