/*
############################################
##           sMotor v0.1 Test Program     ##
##          created by Samuel Matildes    ##
############################################
        ---- sam.naeec@gmail.com -----
This library was made for 4-Phase Stepper Motors
I don't take any resposability for the damage caused to your equipment.

*/

#include "mbed.h"
#include "sMotor.h"
#include "UIPEthernet.h"


Serial pc(USBTX, USBRX);
sMotor motor(A0, A1, A2, A3); // set the pin  sMotor motor(pin1--blueline ,pin2--pinkline ,pin3--yellowline ,pin4--orangeline)
DigitalIn Button(D10);
DigitalIn set_zero_point(D11);
DigitalOut LED(D12);




int step_speed = 1200 ; // set default motor speed
int numstep = 512 ; // defines full turn of 360 degree
int zerocount = 0 ;
int old_zerocount = 0 ;
int set_zero_step = 0 ;

//int delaytime = 1200;
//you might want to calibrate this value according to your motor




const uint8_t   MY_MAC[6] = { 0x74,0x69,0x69,0x2D,0x30,0x31 };
// IP address must be unique and compatible with your network.
const IPAddress MY_IP(192, 168, 1, 181);
const uint16_t  MY_PORT = 7;
const char*     message = "Response successed!";


UIPEthernet     uIPEthernet(A6, A5, A4, D3);    // mosi, miso, sck, cs
UIPUDP          udp;






//////////////////////////////////////////////////////////////////////////////////////////////


int b=0;   //要到度數
//const char* mesg;
int e=0;   //b的記憶體
//const char* message[3]; 

int c=0; //現在整數步數
int vardegree;//度數變化量
int memory=1;//記憶度數
int memorydegree=0;//記憶上次度數

void scan_int(int);//讀取函數
int trans(int);//轉換函數



///////////////////////////////////////////////////////////////////////////////////////////////



int main(void) 
{
    
    
////////////////////////////////////歸零///////////////////////////////////////////////////////////
    
    LED = 1 ;                                   // if don't setzero LED is lighting
    printf("Haven't set_zero_point\n\r");
    pc.readable();
    motor.setzerostep(numstep,0,step_speed);
 
    while(LED ==1)                                              //LED歸零指式燈
    {
        if( Button == 1 && old_zerocount == zerocount)          //按下按鈕進行手動歸零
        {
            motor.setzerostep(numstep,0,step_speed);
        }
        if(old_zerocount != zerocount)
        {
            printf("Press the botton to set the zero point \n\r");
            old_zerocount = zerocount;
        }
    }
 
 
 
 ////////////////////////////////////////////////////////////////////////////////////////////////////       
        
    uIPEthernet.begin(MY_MAC, MY_IP);

    IPAddress   localIP = uIPEthernet.localIP();
    pc.printf("Local IP = %s\r\n", localIP.toString());
    pc.printf("Initialization ");
    
    //馬達初始化
    printf("4 Phase Stepper Motor v0.1 - Set zero Program\r\n");
    printf("\n\r");    
    //motor.setzerostep(SetZeroStep,0,step_speed); // number of steps, direction, speed
    //printf("Already Set to Zero\n\r");
           
    printf("Enter a number:0~+-180 degree\r\n"); 
    if (udp.begin(MY_PORT))
        pc.printf("succeeded.\r\n");
    else
        pc.printf("failed.\r\n");

    while (1) 
    {
        int success;
        int size = udp.parsePacket();           //Returns the size of the packet in bytes

        if (size > 0) 
        {
////////////////////////////////////////////////////////將收的字串轉成整數///////////////////////////////////////////////////////////////
            do                                                      
            {
                char*   msg = (char*)malloc(size + 1);              //malloc() 運算子會配置一個 int 需要的空間，並傳回該空間的位址，所以使用指標 ptr 來儲存這個位址
                int     len = udp.read(msg, size + 1);
                msg[len] = 0;//??不懂
                
                //mesg=msg;
                b = atoi((char*)msg);                               //字串轉數字
                pc.printf("Integer number: %d\r\n",b);
                
                //printf("received mesg: '%s", mesg);
                printf("received: '%s", msg);                
                
                free(msg);
            } while ((size = udp.available()) > 0);

            //finish reading this packet:
            udp.flush();
            printf("'\r\n");
            
            
 
 ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            

            do 
            {
                //send new packet back to ip/port of client. This also
                //configures the current connection to ignore packets from
                //other clients!
                success = udp.beginPacket(udp.remoteIP(), udp.remotePort());
                if (success)
                    pc.printf("beginPacket: succeeded%\r\n");
                else
                    pc.printf("beginPacket: failed%\r\n");

                //beginPacket fails if remote ethaddr is unknown. In this case an
                //arp-request is send out first and beginPacket succeeds as soon
                //the arp-response is received.
            } while (!success);

            success = udp.write((uint8_t*)message, strlen(message));//response

            if (success)
                pc.printf("bytes written: %d\r\n", success);

            success = udp.endPacket();

            if (success)
                pc.printf("endPacket: succeeded%\r\n");
            else
                pc.printf("endPacket: failed%\r\n");

            udp.stop();

            //restart with new connection to receive packets from other clients
            if (udp.begin(MY_PORT))
                pc.printf("restart connection: succeeded%\r\n");
            else
                pc.printf("restart connection: failed%\r\n");
                //馬達開始
            if(b>180|b<-180)
            {
                printf("Enter a number:0~+-180 degree\r\n");
            }    
            else if (b>=-180 & b<=180)
            {    
                if(b!=memory)
                {
            
                    printf("Now b: %d\n\r", b);
                    scan_int(b);
                    c=trans(vardegree);
                
                    if (b > memorydegree)
                    {     
                        motor.step(c,0,step_speed); // dir=0; 順時鐘
                        //printf("Current b: %d\n\r", b);
                    }
                    if (b < memorydegree)
                    {
                        motor.step(c,1,step_speed);//dir=1;逆時鐘
                        //printf("Current b: %d\n\r", b);                              
                    }
                        printf("Enter a number:0~+-180 degree\r\n");
                    
                    memorydegree=b;
                    //printf("memorydegree: %d\n\r",memorydegree);
                    memory=b;
                }  
                //wait(1);         
            } 
        }
    }
        
        
        
        
        
        
///////////////////////////////////////////////////////////////////////////////////////////////        
        
        
        
        
        
        
        
        
        
        
        
        printf("Default Speed: %d\n\r",step_speed);
        printf("1- 360 degree clockwise step\n\r");
        printf("2- 360 degree anticlockwise step\n\r");
        printf("3- 180 degree clockwise step\n\r");
        printf("4- 180 degree anticlockwise step\n\r");
        printf("5- Change Speed\n\r");
        
        
        
        while(1)
        {
             if (pc.readable()) 
                    { // checks for serial

                        if (pc.getc()=='1')
                            motor.step(numstep,0,step_speed); // number of steps, direction, speed

                        if (pc.getc()=='2')
                            motor.step(numstep,1,step_speed);

                        if (pc.getc()=='3')
                            motor.step(numstep/2,0,step_speed);

                        if (pc.getc()=='4')
                            motor.step(numstep/2,1,step_speed);

                        if (pc.getc()=='5') 
                            {
                                printf("Current Speed: %d\n\r", step_speed);
                                printf("New speed: \n\r");
                                pc.scanf("%d",&step_speed); // sets new speed
                            }
                    }           
        }
    
    
}





void sMotor::setzerostep(int SetZeroSteps, int direction, int step_speed) 
{// steper function: number of steps, direction (0- right, 1- left), speed (default 1200)
    //printf("test\r\n");
    int count=0; // initalize step count
    if (direction==0) // turn clockwise
    {
       printf("test");
      do 
        {
           SetZeroClockWise();
           count++;
        }while (count<numstep & set_zero_point==0); // turn number of steps applied  
        if (set_zero_point==1) // 如果光遮斷器訊號被中斷則LED亮起。
        {
            LED=0;
            printf("Already Set to Zero\n\r");            
        }   
        //printf("test\r\n");
         
          
          
    }   
    zerocount++;             
}   








void sMotor::SetZeroClockWise()
{
    
    //set_zero_step = setzeroclockwise;
    for(int i = 0 ; i < 8 ; i++)
    {
        //i = set_zero_step%8;
        switch (i) 
        {
            case 0: 
            {
                _A0=1;
                _A1=0;
                _A2=0;
                _A3=1;
            }
            break;
            case 1: 
            {
                _A0=1;
                _A1=0;
                _A2=0;
                _A3=0;
            }
            break;
            case 2: 
            {
                _A0=1;
                _A1=1;
                _A2=0;
                _A3=0;
            }
            break;
            case 3: 
            {
                _A0=0;
                _A1=1;
                _A2=0;
                _A3=0;
            }
            break;
            case 4: 
            {
                _A0=0;
                _A1=1;
                _A2=1;
                _A3=0;
            }
            break;
            case 5: 
            {
                _A0=0;
                _A1=0;
                _A2=1;
                _A3=0;
            }
            break;
            case 6: 
            {
                _A0=0;
                _A1=0;
                _A2=1;
                _A3=1;
            }
            break;
            case 7: 
            {
                _A0=0;
                _A1=0;
                _A2=0;
                _A3=1;
            }
            break;
        }//switch
        wait_us(step_speed); // wait time defines the speed          
    }//for
  
}








 void scan_int(int scan)//變化量函數
{
    //scanf("%d",&b);
    //printf("Enter b: %d\n\r",b);
    
    vardegree=b-memorydegree;//變化量=輸入度數-上次度數
    printf("vardegree: %d\n\r",vardegree);    
    fflush(stdout);

}
int trans(int trans)//度數轉步數
{
    float numstep = 0 ; // defines full turn of 360 degree
    int d=0;
    numstep=1.422222*trans;//取實際步數值
    if(numstep<0)
    {
        numstep=-numstep;
    }
    d=int(numstep+0.5);//四捨五入整數步數
    //printf("Real steps d: %d\n\r",d);    
    return d;
}