////////////////////////////////////////////////////////////////////////////////////////////
////////     This is the embedded systems project software                        //////////
////////                    Created 9.10.2019                                     //////////
////////     Owners: Lauri Peltoniemi & Sauli Haukka                              ////////// 
////////////////////////////////////////////////////////////////////////////////////////////


// Includes for all components

#include "mbed.h"
#include "LSM6DS3.h"
#include "C12832.h"
//#include "SDFileSystem.h"  // Not implemented yet due to the lack of memory in board

// Defines for all components

  // refresh time. set to 500 for part 2 and 50 for part 4
  #define REFRESH_TIME_MS 1000


// Variables for different purposes

float acc_total = 0;
int meas_done = 0;
float gyro = 0;
float acc_total_diff = 0;
int i = 0;
float acc_record = 0;
float hits = 0;
//float acc_table[1000] = {0,0};  //Not implemented yet since used in sd 

// Components and pin initializations

C12832 lcd(PA_7, PA_5, PA_9, PA_1, PA_0);     // Display
LSM6DS3  sensor(PF_0, PF_1);                  // Accelerometer - Gyroscope sensor
InterruptIn button1(PB_3);                    // Button 1
DigitalIn   button2(PA_4);                    // Button 2... Dummy atm
PwmOut      speaker(PA_8);                    // pietso speaker
DigitalOut  led(LED1);                        // led (green) in stm32 board, in case if needed
//SDFileSystem sd(PA_7, PA_6, PA_5, PA_2, "sd");  // SDCard / SDCard reader
          
// Function declarations for this main.cpp 

void inc_menu();
void menu();
void movement();


//Init Serial port and LSM6DS3 chip
void setup()
{
    // Use the begin() function to initialize the LSM9DS0 library.
    // You can either call it with no parameters (the easy way):
    // SLEEP
    //uint16_t status = imu.begin(imu.G_SCALE_245DPS, imu.A_SCALE_2G,
//                                imu.G_POWER_DOWN, imu.A_POWER_DOWN);
    // LOWEST
      uint16_t status = sensor.begin(sensor.G_SCALE_500DPS, sensor.A_SCALE_2G,
                               sensor.G_ODR_13_BW_0, sensor.A_ODR_13);
    // HIGHEST
      //uint16_t status = sensor.begin(sensor.G_SCALE_2000DPS, sensor.A_SCALE_8G,
                              // sensor.G_ODR_1660, sensor.A_ODR_6660);
}

void menu(){
    
    lcd.cls(); 
    
    while(1){
       
    meas_done = 0;   
       
    speaker.period_ms(0);
    speaker.pulsewidth_ms(0);
       
    lcd.locate(0,3);
    lcd.printf("Press right button ");
    lcd.locate(0,15);
    lcd.printf("to start measurement ");

    // Go to inreasing tone mode
    button1.fall(&inc_menu);

    }
  }
    
void inc_menu(){
    
    if(meas_done == 0){ 
    lcd.cls();    
    lcd.locate(0,3);
    lcd.printf(" Starting  ");
    lcd.locate(0,15);
    lcd.printf(" measurement...  ");
    wait(2.0);
    
    hits = 0;
    
    movement();
    }
    else        // Breaks to main menu if measurement is done, sd saving here also
    
                                  /*  mkdir("/sd/Sulari", 0777);
    
                              FILE *fp = fopen("/sd/Sulari/Acceleration.txt", "w");
                                if(fp == NULL) {
                              error("Could not open file for write\n");
                                }
                              fprintf(fp, "%2f\r\n", acc_table");
                                fclose(fp); */
    
    
      lcd.cls();
      wait(2.0);
      return;
    }

void movement() {
    
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf(" Move the device! ");
    lcd.locate(0,15);
    lcd.printf("      3");
    wait(1.0);
    
    lcd.locate(0,15);
    lcd.printf("      2");
    wait(1.0);
    
    lcd.locate(0,15);
    lcd.printf("      1");    
    wait(1.0);
    
    lcd.cls();
    
    while(1){  //Loop for real timed acceleration measurement
    
    sensor.readAccel();
    
    acc_total = 100 * sqrt((abs((sensor.ax )* (sensor.ax )) + abs(sensor.ay * sensor.ay) + abs(sensor.az * sensor.az))); //Calculates the total acceleration,
    i = i+1;                                                                                                             //scaled for achieving proper values!
    
    if (acc_total < acc_total_diff + 0.8 and acc_total > acc_total_diff -0.8){  //Device is silent if no acceleration detected
      speaker.period_ms(0);
      speaker.pulsewidth_ms(0);
      }    
    
    else if(acc_total > 70 and acc_total < 80){
      speaker.period_ms(20);
      speaker.pulsewidth_ms(1);
      }
    
    else if(acc_total > 80 and acc_total < 90){
      speaker.period_ms(15);
      speaker.pulsewidth_ms(1);
      }
    
    else if(acc_total > 90 and acc_total < 100){
      speaker.period_ms(10);
      speaker.pulsewidth_ms(1);
      }
      
    else if(acc_total > 100 and acc_total < 110){
      speaker.period_ms(5);
      speaker.pulsewidth_ms(1);
      }

    else if(acc_total > 110 and acc_total < 120){
      speaker.period_ms(3);
      speaker.pulsewidth_ms(1);
      }
    
    else if(acc_total > 120){
      speaker.period_ms(2);
      speaker.pulsewidth_ms(1);
      }
    
    if(acc_total < 99 and acc_total > 98 and sensor.az < -0.94 and sensor.az > -0.99){ 
      speaker.period_ms(0);
      speaker.pulsewidth_ms(0);
    
      lcd.cls();
      lcd.locate(0,3);
      lcd.printf(" Exit in 3 ");
      wait(1.0);
    
      if(sensor.az <-0.94 and sensor.az > -0.99){
        lcd.locate(0,3);
        lcd.printf(" Exit in 2 ");
        wait(1.0);
    
        if(sensor.az <-0.94 and sensor.az > -0.99){
          lcd.locate(0,3);
          lcd.printf(" Exit in 1 ");
          wait(1.0);
    
          if(sensor.az <-0.94 and sensor.az > -0.99){ 
            lcd.cls();
            lcd.locate(0,3);
            lcd.printf(" Thank you! ");
            wait(1.0);
            
            lcd.cls();
            lcd.locate(0,3);                              //Shows the number of hits 
            lcd.printf(" Total number of hits: ");
            lcd.locate(15,15);
            lcd.printf(" %2f\r\n", hits );  
            wait(2.0);
    
            meas_done = 1;
    
            break;
            }
          }
        }
      }
      
    lcd.locate(0,3);                              //Keep the highest acceleration on display
    lcd.printf(" Highest acceleration: ");
    lcd.locate(15,15);
    lcd.printf(" %2f\r\n", (acc_record /100));  //Shows acceleration in G-forces
    
    if (acc_total > acc_record){  //Keep up on the highest acceleration so far
        acc_record = acc_total;
        }
  
    if ((acc_total > 100 or acc_total < 95) and acc_total_diff < 100 and acc_total_diff > 95){
        hits = hits + 1;
        } 
        
    acc_total_diff = acc_total;
    //acc_table[i] = acc_total;   //For sd saving
    
    }  //While loop ends here
    
    }


int main()
{
    // Setup devices here
    setup();  //Setup sensor and Serial
    
    // Power up welcome screen
    lcd.cls();  //Clear screen
    lcd.locate(0,3);
    lcd.printf("\r\n   Hello!   \r\n");
    wait(2.0);
    
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("\r\n  Let's start! \r\n");
    wait(2.0);
    lcd.cls();
    
    // Go to main menu
    menu();
    
}
