// LSM6DS3 Demo

#include "mbed.h"
#include "LSM6DS3.h"
#include "C12832.h"

// refresh time. set to 500 for part 2 and 50 for part 4
#define REFRESH_TIME_MS 1000

// Verify that the pin assignments below match your breadboard

C12832 lcd(PA_7, PA_5, PA_9, PA_1, PA_0);
LSM6DS3  sensor(PF_0, PF_1);

//Init Serial port and LSM6DS3 chip
void setup()
{
    // Use the begin() function to initialize the LSM9DS0 library.
    // You can either call it with no parameters (the easy way):
    // SLEEP
    //uint16_t status = imu.begin(imu.G_SCALE_245DPS, imu.A_SCALE_2G,
//                                imu.G_POWER_DOWN, imu.A_POWER_DOWN);
    // LOWEST
    //uint16_t status = imu.begin(imu.G_SCALE_245DPS, imu.A_SCALE_2G,
//                                imu.G_ODR_13_BW_0, imu.A_ODR_13);
    // HIGHEST
    uint16_t status = sensor.begin(sensor.G_SCALE_2000DPS, sensor.A_SCALE_8G,
                                sensor.G_ODR_1660, sensor.A_ODR_6660);

    //Make sure communication is working
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("LSM6DS3 WHO_AM_I's returned: 0x%X\r\n", status);
    wait(1.0);
    lcd.locate(0,15);
    lcd.printf("Should be 0x69\r\n");
    wait(1.0);
}

int main()
{
    setup();  //Setup sensor and Serial
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("\r\n----Mitataan!----\r\n");
    wait(1.0);

    while (true)
    {
        sensor.readTemp();
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Temp:\r\n");
        lcd.locate(15,15);
        lcd.printf("TC: %2f\r\n", sensor.temperature_c);
        wait(1.0);
        lcd.cls();
        lcd.locate(15,15);
        lcd.printf("TF: %2f\r\n", sensor.temperature_f);
        wait(2.0);
        
        sensor.readAccel();
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Accel:\r\n");
        lcd.locate(15, 15);
        lcd.printf("AX: %2f\r\n", sensor.ax);
        wait(1.0);
        lcd.cls();
        lcd.locate(15,15);
        lcd.printf("AY: %2f\r\n", sensor.ay);
        wait(1.0);
        lcd.cls();
        lcd.locate(15,15);
        lcd.printf("AZ: %2f\r\n", sensor.az);
        wait(1.0);
        wait(2.0);

        sensor.readGyro();
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Gyro:\r\n");
        lcd.locate(15, 15);
        lcd.printf("GX: %2f\r\n", sensor.gx);
        wait(1.0);
        lcd.cls();
        lcd.locate(15, 15);
        lcd.printf("GY: %2f\r\n", sensor.gy);
        wait(1.0);
        lcd.cls();
        lcd.locate(15, 15);
        lcd.printf("GZ: %2f\r\n\r\n", sensor.gz);
        wait(2.0);
       
        wait_ms(REFRESH_TIME_MS);
    }
}
