/* 

@Acknowledgements to (c) Craig A. Evans, University of Leeds, Feb 2016 for Temp Library
@Acknowledgements to (c) Dr. Edmond Nurellari, University of Lincoln, Dec 2021 for Classes used

@Using Various Libraries & Functions in order to create a 
@Temperature Based Health Assistive Smart Device
@In the form of a Smart Tap which will assist users in every day tasks to
@prevent illness and injury

*/ 

/*
======================== Library Imports =======================================
Importing the Header Files from the Class Libraries into the main.cpp
*/
#include "mbed.h"                              // Mbed OS Library
#include "TMP102.h"                            // TMP102 Header File
#include "N5110.h"                             // N5110 Header File 
#include "Bitmap.h"                            // Bitmap Header File 
#include "Joystick.h"                          // Joystick Header File

/*
========================== Vairable Setup ======================================
Pre-Determining the various Variable names to hardware pins on the K64F Board
*/

TMP102 Tmp(I2C_SDA,I2C_SCL);                   // Create TMP102 object
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);     // Create lcd objec
Serial serial(USBTX,USBRX);                    // CoolTerm TX, RX Comms Setup for Debug
AnalogIn SetP(PTB2);                           // Potentiometer for Setpoint
Joystick Joystick(PTB10,PTB11,PTC16);          // Create Joystick (PTB10 = Up/Down) (PTB11 = L/R) (PTB16 = Button)

DigitalOut RED_led(LED_RED);                   // On-board K64F LED'S
DigitalOut GRN_led(LED_GREEN);
DigitalOut BLU_led(LED_BLUE);

DigitalOut Clg_LED(PTA2);                      // Green LED on PCB for Cooling                     
DigitalOut Ready_LED(PTA1);                    // Green LED on PCB for when water is ready
DigitalOut Htg_LED(PTC3);                      // Red LED on PCB for Cooling
DigitalOut Boil_LED(PTD3);                      

InterruptIn sw2(SW2);                          // On-board K64F Switches
InterruptIn sw3(SW3);
InterruptIn R(PTB3);                           // Right Bumper Button
InterruptIn L(PTB18);                          // Left Bumper Button
InterruptIn A(PTB9);                           // A button Button
InterruptIn Y(PTC12);                          // Y Button Button

                                               // Interrupt Services volatile flag which will change within the isr
volatile int g_R_flag = 0;                     // g_ in order to show it is a global variable. 
volatile int g_L_flag = 0;                    
volatile int g_A_flag = 0;                    
volatile int g_Y_flag = 0;                    

/*
========================= Void Declaration =====================================
Functions to be called throughout code in order to improve readability
*/
void error();                                  // Error Hang Code Function
void init_serial();                            // Setup serial port Function
void init_K64F();                              // K64F Disabling Onboard Components Function


void R_isr();                                  // Interrupt Voids
void L_isr();
void A_isr();
void Y_isr();

                                                // Display Screen Voids used in the Menu
void info();                                   
void Page0();
void Page1();
void Page2();
void Home();

void MenuNav();                                // Menu Navigation using the Joystick to move Left & Right

void Custom();                                 // Custom Setpoint - Mode Function
void T_SP_Pg0();
void HtgClg_Pg0();

void WWtr();                                   // Page 1 - Mode Functions
void T_SP_Pg1();                               
void HtgClg_Pg1();

void CWtr();                                   // Page 2 - Mode Functions
void T_SP_Pg2();                               
void HtgClg_Pg2();

void BWtr();                                   // Page 2 - Mode Functions
void T_SP_Pg3();                               
void HtgClg_Pg3();

/*======================== Main Function =====================================*/

int Setpoint[4] = {8,37,80,24};                 // Setpoint Array to be used dependant on Mode Selected

int main()
{
    
    init_K64F();                                // Initialise K64F Board
    init_serial();                              // Initialise Serial Port
    Tmp.init();                                 // Initialise Temp Sensor Libraries
    lcd.init();                                 // Initialise LCD
    Joystick.init();                            // Initialise Joystick
           
    lcd.setContrast(0.4);                       // Setup the contrast for the LCD Screen
    
    R.fall(&R_isr);                             // Flipping the Interrupt Function
    R.mode(PullDown);                           // When the PCB Button is Pulled Down
    
    L.fall(&L_isr);
    L.mode(PullDown);
    
    A.fall(&A_isr);
    A.mode(PullDown);
    
    Y.fall(&Y_isr);
    Y.mode(PullDown);
        
    Clg_LED = 1;                                // Disabling the LED's
    Ready_LED = 1;
    Htg_LED = 1;
    Boil_LED = 1;
    
    while (1) {                
        MenuNav();                                                                                                                                                      
    }

}


/*
=========================== Void Setup =========================================
Custom Function's are called Void's, which are called upon inside the of the
Main Function Code
*/

void init_serial() 
{
    /** Serial Port Communications
     * Initialise the serial communication port for communication
     * to CoolTerm in order to Debug the code through various parts
     */
    serial.baud(9600);                  // Baud Rate Communication for CoolTerm Debugging                          
}

void init_K64F() 
{
    /* K64F Board Set up
     * since the on-board switches have external pull-ups, disable the 
     * internal pull-down resistors that are enabled by default using
     * the InterruptIn Command */
        
    RED_led = 1;                        // on-board LEDs are active when 0, so setting the pin to 1 turns them off
    GRN_led = 1;
    BLU_led = 1;       
                       
    sw2.mode(PullNone);
    sw3.mode(PullNone);
}

void R_isr()                            // Right Bumper Interrupt Service     
{
    g_R_flag = 1;                       // set flag in ISR
}

void L_isr()                            // Left Bumper Interrupt Service     
{
    g_L_flag = 1;                       // set flag in ISR
}
void A_isr()                            // A Button Interrupt Service     
{
    g_A_flag = 1;                       // set flag in ISR
}
void Y_isr()                            // Y Button Interrupt Service     
{
    g_Y_flag = 1;                       // set flag in ISR
}
void info()
{
        /** Printing Information Page
          * Pre-defined software information page to be printed when called upon
        */
        
        //serial.printf(" Information Page Selected ");    // Debugging Print
        lcd.clear();                                       // Clear Screen
        lcd.printString("  Info Page   ",0,0);             // Print Information Screen
        lcd.printString("  Author: LM  ",0,1);
        lcd.printString("   18689006   ",0,2);
        lcd.printString("   Version 1  ",0,3);
        lcd.printString("   R = Home   ",0,4);
        lcd.printString("  A = Select  ",0,5);   
        
        lcd.refresh();                                     // Refresh & Display printed strings to LCD
        wait(1);

} 
void Home()
{              
        /** Printing Home Page
          * Pre-defined Home page to be printed when called upon
        */
        
        //serial.printf("Home Menu");                    // Debugging Print
        lcd.clear();                                     // Clear Screen
        lcd.printString("   Navigate  >",0,0);           // Print Home Screen
        lcd.printString(" Use Joystick ",0,1);
        lcd.printString("   Welcome   ",0,3);           
        lcd.printString("  Main Menu: ",0,4); 
        lcd.printString("  Y for Info  ",0,5);   
                
        lcd.refresh();                                   // Refresh & Display printed strings to LCD
        wait(1);
                
            if (g_Y_flag){                               // Condition to change over into new loop
                g_Y_flag = 0;                            // When the Button has been pressed
                Y.rise(&Y_isr);
                //serial.printf("Y Pressed");            // Debugging Print
                info();                                  // Display Information Screen                
                       }
}
void Page0()
{        
        /** Printing Page 0
          * Pre-defined PCustom Page to be printed when called upon
        */
        
        //serial.printf(" Custom Page ");                  // Debugging Print
        lcd.clear();                                       // Clear Screen
        lcd.printString("<   Custom   >",0,0);             // Print Page 1 Screen
        lcd.printString("     MODE:    ",0,1);
        lcd.printString("    Custom    ",0,2);
        lcd.printString("   Setpoint   ",0,3);
        lcd.printString("    Press A   ",0,4);
           
        lcd.refresh();                                     // Refresh & Display printed strings to LCD
        wait(1);
        
            if (g_A_flag){                                 // Condition to change over into new loop
                g_A_flag = 0;                              // When the A Flag has been pressed
                A.rise(&A_isr);
                //serial.printf("A Pressed");              // Debugging Print
                Custom();                                  // Select Custom Mode
                wait(1);
                        }
}
void Page1()
{        
        /** Printing Page 1
          * Pre-defined Page 1 to be printed when called upon
        */
        
        //serial.printf(" Page 1 ");                       // Debugging Print
        lcd.clear();                                       // Clear Screen
        lcd.printString("<   Page 1   >",0,0);             // Print Page 1 Screen
        lcd.printString("     MODE:    ",0,1);
        lcd.printString("Washing Water",0,2);
        lcd.printString("    Press A   ",0,3);
           
        lcd.refresh();                                     // Refresh & Display printed strings to LCD
        wait(1);
        
            if (g_A_flag){                                 // Condition to change over into new loop
                g_A_flag = 0;                              // When the A Flag has been pressed
                A.rise(&A_isr);
                //serial.printf("A Pressed");              // Debugging Print
                WWtr();                                    // Select Mode 2
                wait(1);
                        }
}
void Page2()
{       
        /** Printing Page 2
          * Pre-defined Page 2 to be printed when called upon
        */ 
        
        //serial.printf(" Page 2 ");                        // Debugging Print
        lcd.clear();                                        // Clear Screen
        lcd.printString("<   Page 2   >",0,0);              // Print Information Screen
        lcd.printString("     MODE:    ",0,1);
        lcd.printString("Drinking Water",0,2);
        lcd.printString("    Press A   ",0,3);
           
        lcd.refresh();                                      // Refresh & Display printed strings to LCD
        wait(1);
         
             if (g_A_flag){                                 // Condition to change over into new loop
                 g_A_flag = 0;                              // When the R Flag has been pressed
                 A.rise(&A_isr);
                 serial.printf("A Pressed");                // Debugging Print
                 CWtr();                                    // Select Mode 3
                 wait(1);
                        }                       
}
void Page3()
{        
        /** Printing Page 3
          * Pre-defined Page 3 to be printed when called upon
        */
        
        //serial.printf(" Page 3 ");                   // Debugging Print
        lcd.clear();                                   // Clear Screen
        lcd.printString("<   Page 3",0,0);             // Print Information Screen
        lcd.printString("     MODE:    ",0,1);
        lcd.printString("Boiling Water",4,2);
        lcd.printString("    Press A   ",0,3);
           
        lcd.refresh();                                 // Refresh & Display printed strings to LCD
        wait(1);
         
            if (g_A_flag){                             // Condition to change over into new loop
                g_A_flag = 0;                          // When the A Flag has been pressed
                A.rise(&A_isr);
                //serial.printf("A Pressed");          // Debugging Print
                BWtr();                                // Select Mode 3
                wait(1);
                        }                       
}   
void MenuNav()
{ 
  /** Menu Navigation Function
      * Using the Joystick and a Switch-Case Function Operation
      * in order to build the menu system that will be printing
      * onto the LCD N5110 Screen by calling upon funcitons
    */
    
    lcd.clear();                                            // Clear LCD Screen
    lcd.refresh();                                          // Refresh & Display printed strings to LCD
    
    int Mode = 0;                                           // Initialise Mode to 0
    while (1){
        
    //serial.printf("Direction = %i ",d);                   // Debugging Print
    Direction d = Joystick.get_direction();                 // Joystick Direction used in order to switch between modes

        switch(Mode) {                                      // Main External Switch to detetermine Mode              
            case 0:                                         // Main Initial Case instance
                switch(d) {                                 // Looking at the Joystick Direction for internal switch
                    case W:                                 // If the direction is W (Left) carry out Case W
                        wait(0.5);                          // Delay added to allow for joystick movement
                        Mode = 0;                           // Remain in Mode 0 - Prevents idol cycling through the switch
                        //serial.printf("LEFT.0");          // Debugging Print to see which state the Main switch is at via Direction           
                        break;                              // Break out from Loop
                    case E:                                 // If the direction is E (Right) carry out Case E
                        wait(0.5);                          // Delay added to allow for joystick movement
                        Mode = 1;                           // Switch to Mode 1 
                        //serial.printf("RIGHT.0");         // Debugging Print
                        break;                              // Break out from Loop
                          }
                break;                                      // Break out from Loop into Main Switch
            
            case 1:                                         // Main Initial Case instance - When at Page 1
                switch(d) {                                 // Looking at the Joystick Direction for internal switch
                    case W:                                 // If the direction is W (Left) carry out Case W
                        wait(0.5);                          // Delay added to allow for joystick movement
                        Mode = 0;                           // Return to Mode 0
                        //serial.printf("LEFT.1");          // Debugging Print                
                        break;                              // Break out from Loop
                    case E:                                 // If the direction is E (Right) carry out Case E
                        wait(0.5);                          // Delay added to allow for joystick movement
                        Mode = 2;                           // Switch to Mode 0                           
                        //serial.printf("RIGHT.1");         // Debugging Print
                        break;                              // Break out from Loop
                          }
                break;                                      // Break out from Loop into Main Switch
            
            case 2:                                         // Main Initial Case instance - When at Page 2
                switch(d) {                                 // Looking at the Joystick Direction for internal switch
                    case W:                                 // If the direction is W (Left) carry out Case W
                        wait(0.5);                          // Delay added to allow for joystick movement
                        Mode = 1;                           // Return to Mode 1
                        //serial.printf("LEFT.2");          // Debugging Print
                        break;                              // Break out from Loop
                    case E:                                 // If the direction is E (Right) carry out Case E
                        wait(0.5);                          // Delay added to allow for joystick movement
                        Mode = 3;                           // Remain in Mode 2 - Prevents idol cycling through the switch
                        //serial.printf("RIGHT.2");         // Debugging Print
                        break;                              // Break out from Loop
                          }
                break;                                      // Break out from Loop into Main Switch
            
            case 3:                                         // Main Initial Case instance - When at Page 3
                switch(d) {                                 // Looking at the Joystick Direction for internal switch
                    case W:                                 // If the direction is W (Left) carry out Case W
                        wait(0.5);                          // Delay added to allow for joystick movement
                        Mode = 2;                           // Return to Mode 1
                        //serial.printf("LEFT.3");          // Debugging Print
                        break;                              // Break out from Loop
                    case E:                                 // If the direction is E (Right) carry out Case E
                        wait(0.5);                          // Delay added to allow for joystick movement
                        Mode = 4;                           // Remain in Mode 2 - Prevents idol cycling through the switch
                        //serial.printf("RIGHT.3");         // Debugging Print
                        break;                              // Break out from Loop
                          }
                break;                                      // Break out from Loop into Main Switch
            
            case 4:                                         // Main Initial Case instance - When at Page 2
                switch(d) {                                 // Looking at the Joystick Direction for internal switch
                    case W:                                 // If the direction is W (Left) carry out Case W
                        wait(0.5);                          // Delay added to allow for joystick movement
                        Mode = 3;                           // Return to Mode 1
                        //serial.printf("LEFT.4");          // Debugging Print
                        break;                              // Break out from Loop
                    case E:                                 // If the direction is E (Right) carry out Case E
                        wait(0.5);                          // Delay added to allow for joystick movement
                        Mode = 4;                           // Remain in Mode 2 - Prevents idol cycling through the switch
                        //serial.printf("RIGHT.4");         // Debugging Print
                        break;                              // Break out from Loop
                          }
            break;                                          // Break out from Loop into Main Switch
                default:
                    Mode = 0;
            
            break;
                        }
        wait(0.5);
                                                            // Mode Actions
            if (Mode == 0){                                 // When the Mode is 0                                 
                Home();                                     // Go to Home Page Function
                            }
            else if (Mode == 1){                            // When the Mode is 1
                Page0();                                    // Go to Page 0 Function
                            }
            else if (Mode == 2){                            // When the Mode is 2
                Page1();                                    // Go to Page 1 Function
                            }
            else if (Mode == 3){                            // When the Mode is 3
                Page2();                                    // Go to Page 2 Function
                            } 
            else if (Mode == 4){                            // When the Mode is 4
                Page3();                                    // Go to Page 3 Function
                            }
        }
} 
void Custom()
{
  /** Custom Monitoring Mode
      * Using Parameters for Temperature with a custom setpoint
      */
    while(1){
    
    Setpoint[3] = SetP * 100;
    float T = Tmp.get_temperature();                    // Reading Temperature as a floating variable
    float SP = Setpoint[3];                             // Reading the Setpoint from the Array
    //serial.printf("SP = %.2f \n",CWtr_SP);            // Debugging Print
    //serial.printf("SETPOINT = ",CWtr_SP);             // Debugging Print
        if (SP-1 > T || T > SP+1){                      // If the Temperature is not within the Tolerance
                                
                HtgClg_Pg0();                           // Heating Cooling Control Function
                lcd.clear();                            // Clear LCD Screen
                T_SP_Pg0();                             // Print Modes Temperature & Setpoint info
                lcd.printString("  Adjusting   ",0,2);  // Display string on screen, Determine Co-ordinates (..,Column, Row)            
                lcd.printString("  Water Temp  ",0,3);
                lcd.printString(" Please Wait! ",4,4);
                
                lcd.refresh();                          // Refresh & Display printed strings to LCD
                wait(1);
                                            }

        else if (SP-1 <= T <= SP+1){                    // If the Temperature is within the Tolerance
                
                HtgClg_Pg0();                           // Heating Cooling Control Function
                lcd.clear();                            // Clear LCD Screen
                T_SP_Pg0();                             // Print Modes Temperature & Setpoint info
                lcd.printString("  Temperature ",0,2);  // Display string on screen, Determine Co-ordinates (..,Column, Row)
                lcd.printString("   Satisfied  ",0,3);
                lcd.printString("    Ready!    ",4,4);    
                
                lcd.refresh();                          // Refresh & Display printed strings to LCD                          
                Ready_LED = 0;                          // Enable the Ready LED
                wait(1);  
                                            }
            
        if (g_R_flag){                                  // Condition to change over into new loop
                g_R_flag = 0;                           // When the Button has been pressed
                R.rise(&R_isr);                         // Button Rising edge
                //serial.printf("Home Pressed");        // Debugging Print
                
                    Clg_LED = 1;                        // Disable the LED's for next Mode
                    Htg_LED = 1;
                    Ready_LED = 1;
                
                MenuNav();                              // Return to Navigation Menu
                wait(1);
                }
    }
}
void WWtr()
{
  /** Warm Washing Water Mode
      * Using Parameters for Safe Washing Water Temperature
      */
    while(1){
    
    float T = Tmp.get_temperature();                    // Reading Temperature as a floating variable
    float SP = Setpoint[1];                             // Reading the Setpoint from the Array
    //serial.printf("SP = %.2f \n",CWtr_SP);            // Debugging Print
    //serial.printf("SETPOINT = ",CWtr_SP);             // Debugging Print
        if (SP-1 > T || T > SP+1){                      // If the Temperature is not within the Tolerance
                                
                HtgClg_Pg1();                           // Heating Cooling Control Function
                lcd.clear();                            // Clear LCD Screen
                T_SP_Pg1();                             // Print Modes Temperature & Setpoint info
                lcd.printString("  Adjusting   ",0,2);  // Display string on screen, Determine Co-ordinates (..,Column, Row)            
                lcd.printString("  Water Temp  ",0,3);
                lcd.printString(" Please Wait! ",4,4);
                
                lcd.refresh();                          // Refresh & Display printed strings to LCD
                wait(1);
                                            }

        else if (SP-1 <= T <= SP+1){                    // If the Temperature is within the Tolerance
                
                HtgClg_Pg1();                           // Heating Cooling Control Function
                lcd.clear();                            // Clear LCD Screen
                T_SP_Pg1();                             // Print Modes Temperature & Setpoint info
                lcd.printString("     Warm     ",0,2);  // Display string on screen, Determine Co-ordinates (..,Column, Row)
                lcd.printString("Washing Water",0,3);
                lcd.printString("    Ready!    ",4,4);    
                
                lcd.refresh();                          // Refresh & Display printed strings to LCD                          
                Ready_LED = 0;                          // Enable the Ready LED
                wait(1);  
                                            }
            
        if (g_R_flag){                                  // Condition to change over into new loop
                g_R_flag = 0;                           // When the Button has been pressed
                R.rise(&R_isr);                         // Button Rising edge
                //serial.printf("Home Pressed");        // Debugging Print
                
                    Clg_LED = 1;                        // Disable the LED's for next Mode
                    Htg_LED = 1;
                    Ready_LED = 1;
                
                MenuNav();                              // Return to Navigation Menu
                wait(1);
                }
    }
}     
void CWtr()
{
  /** Cold Drinking Water Mode
      * Using Parameters for Safe Drinking Water Temperature
      */
    while(1){
    
    float T = Tmp.get_temperature();                    // Reading Temperature as a floating variable
    float SP = Setpoint[0];                             // Reading the Setpoint from the Array
    //serial.printf("SP = %.2f \n",CWtr_SP);            // Debugging Print
    //serial.printf("SETPOINT = ",CWtr_SP);             // Debugging Print
        if (SP-1 > T || T > SP+1){                      // If the Temperature is not within the Tolerance
                                
                HtgClg_Pg2();                           // Heating Cooling Control Function
                lcd.clear();                            // Clear LCD Screen
                T_SP_Pg2();                             // Print Modes Temperature & Setpoint info
                lcd.printString("  Adjusting   ",0,2);  // Display string on screen, Determine Co-ordinates (..,Column, Row)            
                lcd.printString("  Water Temp  ",0,3);
                lcd.printString(" Please Wait! ",4,4);
                
                lcd.refresh();                          // Refresh & Display printed strings to LCD
                wait(1);
                                            }

        else if (SP-1 <= T <= SP+1){                    // If the Temperature is within the Tolerance
                
                HtgClg_Pg2();                           // Heating Cooling Control Function
                lcd.clear();                            // Clear LCD Screen
                T_SP_Pg2();                             // Print Modes Temperature & Setpoint info
                lcd.printString("     COLD     ",0,2);  // Display string on screen, Determine Co-ordinates (..,Column, Row)
                lcd.printString("Drinking Water",0,3);
                lcd.printString("    Ready!    ",4,4);    
                
                lcd.refresh();                          // Refresh & Display printed strings to LCD                          
                Ready_LED = 0;                          // Enable the Ready LED
                wait(1);  
                                            }
            
        if (g_R_flag){                                  // Condition to change over into new loop
                g_R_flag = 0;                           // When the Button has been pressed
                R.rise(&R_isr);                         // Button Rising edge
                //serial.printf("Home Pressed");        // Debugging Print
                
                    Clg_LED = 1;                        // Disable the LED's for next Mode
                    Htg_LED = 1;
                    Ready_LED = 1;
                
                MenuNav();                              // Return to Navigation Menu
                wait(1);
                }
    }
}
void BWtr()
{
  /** Warm Washing Water Mode
      * Using Parameters for Safe Washing Water Temperature
      */
    while(1){
    
    float T = Tmp.get_temperature();                    // Reading Temperature as a floating variable
    float SP = Setpoint[3];                             // Reading the Setpoint from the Array
    //serial.printf("SP = %.2f \n",CWtr_SP);            // Debugging Print
    //serial.printf("SETPOINT = ",CWtr_SP);             // Debugging Print
        if (SP-1 > T || T > SP+1){                      // If the Temperature is not within the Tolerance
                                
                HtgClg_Pg3();                           // Heating Cooling Control Function
                lcd.clear();                            // Clear LCD Screen
                T_SP_Pg3();                             // Print Modes Temperature & Setpoint info
                lcd.printString("  Adjusting   ",0,2);  // Display string on screen, Determine Co-ordinates (..,Column, Row)            
                lcd.printString("  Water Temp  ",0,3);
                lcd.printString(" Please Wait! ",4,4);
                
                lcd.refresh();                          // Refresh & Display printed strings to LCD
                wait(1);
                                            }

        else if (SP-1 <= T <= SP+1){                    // If the Temperature is within the Tolerance
                
                HtgClg_Pg3();                           // Heating Cooling Control Function
                lcd.clear();                            // Clear LCD Screen
                T_SP_Pg3();                             // Print Modes Temperature & Setpoint info
                lcd.printString("   Boiling   ",0,2);   // Display string on screen, Determine Co-ordinates (..,Column, Row)
                lcd.printString("Boiling Water",0,3);
                lcd.printString("    Ready!    ",4,4);    
                lcd.printString(" WARNING HOT! ",0,5);
                lcd.refresh();                          // Refresh & Display printed strings to LCD                          
                Ready_LED = 0;                          // Enable the Ready LED
                Boil_LED = 0;                           // Enable the Boiling LED
                wait(1);  
                                            }
            
        if (g_R_flag){                                  // Condition to change over into new loop
                g_R_flag = 0;                           // When the Button has been pressed
                R.rise(&R_isr);                         // Button Rising edge
                //serial.printf("Home Pressed");        // Debugging Print
                
                    Clg_LED = 1;                        // Disable the LED's for next Mode
                    Htg_LED = 1;
                    Ready_LED = 1;
                
                MenuNav();                              // Return to Navigation Menu
                wait(1);
                }
    }
}
void T_SP_Pg0()
{
      /** Mode Select = Cutsom
          * When a new mode is selected the LCD screen will update in order 
          * to assist the user with the water temperature in order to provide
          * Assistance, Safety and Comfort
        */
    
    Setpoint[3] = SetP * 100;                                     // Use Potentiometer for custom setpoint and assign value into the array
        
    float T = Tmp.get_temperature();                              // Reading Temperature as a floating variable
    float SP_0 = Setpoint[3];                                     // Reading the Mode Setpoint from the Array 
    char buffer[14];                                              // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14 Max amound of Characters) 
        
        int  length = sprintf(buffer,"T=%.2F 'C",T);              // print the temperature from the float variable T
        if (length <= 14);                                        // Ensuring string will fit on the screen (Printing at x=0)
            lcd.printString(buffer,18,0);                         // Display string on screen, Determine Co-ordinates (..,Column, Row)
            //serial.printf("    T = %f C\n",T);                  // Debugging Print
            
            length = sprintf(buffer,"SP=%.2f 'C",SP_0);           // print the Setpoint from the Setpoint Variable
        if (length <= 14)                                         // Ensuring string will fit on the screen (Printing at x=0)                                                                  
            lcd.printString(buffer,13,1);                         // Display string on screen, Determine Co-ordinates (..,Column, Row)
            //serial.printf("    T = %f C\n",SP_1);               // Debugging Print
}
void HtgClg_Pg0()
{
        /** Water Temperature Control 
            * Control Mode which enables LED's if the temperature goes outside
            * of the +/- Setpoint Tolerance.
            * Dependant on the Mode Application will depend on which setpoint is 
            * selected from the Setpoint Array        
        */
        
        Setpoint[3] = SetP * 100;                   // Use Potentiometer for custom setpoint and assign value into the array
        
        float T = Tmp.get_temperature();            // Reading Temperature as a floating variable
        float SP_0 = Setpoint[3];                   // Reading the Mode Setpoint from the Array
            if (T > SP_0+1){                        // If Temp is above the setpoint
                Clg_LED = 0;                        // Enable the Cooling LED
                Htg_LED = 1;                        // Disable other LED's
                Ready_LED = 1;
                //serial.printf("Cooling");         // Debugging Print
                              }
            else if (T < SP_0-1){                   // If Temp is below the setpoint
                Htg_LED = 0;                        // Enable the Heating LED
                Clg_LED = 1;                        // Disable other LED's
                Ready_LED = 1;
                //serial.printf("Heating");         // Debugging Print
                                   }
            else {                                  // If none of the conditions are satisfied
                Clg_LED = 1;                        // Disable Heating & cooling LED's
                Htg_LED = 1;                    
                 }
}
void T_SP_Pg1()
{
      /** Mode Select = Washing Water
          * When a new mode is selected the LCD screen will update in order 
          * to assist the user with the water temperature in order to provide
          * Assistance, Safety and Comfort
        */
        
    float T = Tmp.get_temperature();                              // Reading Temperature as a floating variable
    float SP_1 = Setpoint[1];                                     // Reading the Mode Setpoint from the Array 
    char buffer[14];                                              // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14 Max amound of Characters) 
        
        int  length = sprintf(buffer,"T=%.2F 'C",T);              // print the temperature from the float variable T
        if (length <= 14);                                        // Ensuring string will fit on the screen (Printing at x=0)
            lcd.printString(buffer,18,0);                         // Display string on screen, Determine Co-ordinates (..,Column, Row)
            //serial.printf("    T = %f C\n",T);                  // Debugging Print
            
            length = sprintf(buffer,"SP=%.2f 'C",SP_1);           // print the Setpoint from the Setpoint Variable
        if (length <= 14)                                         // Ensuring string will fit on the screen (Printing at x=0)                                                                  
            lcd.printString(buffer,13,1);                         // Display string on screen, Determine Co-ordinates (..,Column, Row)
            //serial.printf("    T = %f C\n",SP_1);               // Debugging Print
}
void HtgClg_Pg1()
{
        /** Water Temperature Control 
            * Control Mode which enables LED's if the temperature goes outside
            * of the +/- Setpoint Tolerance.
            * Dependant on the Mode Application will depend on which setpoint is 
            * selected from the Setpoint Array        
        */
        
        float T = Tmp.get_temperature();            // Reading Temperature as a floating variable
        float SP_1 = Setpoint[1];                   // Reading the Mode Setpoint from the Array
            if (T > SP_1+2){                        // If Temp is above the setpoint
                Clg_LED = 0;                        // Enable the Cooling LED
                Htg_LED = 1;                        // Disable other LED's
                Ready_LED = 1;
                //serial.printf("Cooling");         // Debugging Print
                              }
            else if (T < SP_1-2){                   // If Temp is below the setpoint
                Htg_LED = 0;                        // Enable the Heating LED
                Clg_LED = 1;                        // Disable other LED's
                Ready_LED = 1;
                //serial.printf("Heating");         // Debugging Print
                                   }
            else {                                  // If none of the conditions are satisfied
                Clg_LED = 1;                        // Disable Heating & cooling LED's
                Htg_LED = 1;                    
                 }
}
void T_SP_Pg2()
{
      /** Mode Select = Drinking Water
          * When a new mode is selected the LCD screen will update in order 
          * to assist the user with the water temperature in order to provide
          * Assistance, Safety and Comfort
        */
        
    float T = Tmp.get_temperature();                              // Reading Temperature as a floating variable
    float SP_2 = Setpoint[2];                                     // Reading the Mode Setpoint from the Array 
    char buffer[14];                                              // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14 Max amound of Characters) 
        
        int  length = sprintf(buffer,"T=%.2F 'C",T);              // print the temperature from the float variable T
        if (length <= 14);                                        // Ensuring string will fit on the screen (Printing at x=0)
            lcd.printString(buffer,18,0);                         // Display string on screen, Determine Co-ordinates (..,Column, Row)
            //serial.printf("    T = %f C\n",T);                  // Debugging Print
            
            length = sprintf(buffer,"SP=%.2f 'C",SP_2);           // print the Setpoint from the Setpoint Variable
        if (length <= 14)                                         // Ensuring string will fit on the screen (Printing at x=0)                                                                  
            lcd.printString(buffer,13,1);                         // Display string on screen, Determine Co-ordinates (..,Column, Row)
            //serial.printf("    T = %f C\n",SP_2);               // Debugging Print
}
void HtgClg_Pg2()
{
        /** Water Temperature Control 
            * Control Mode which enables LED's if the temperature goes outside
            * of the +/- Setpoint Tolerance.
            * Dependant on the Mode Application will depend on which setpoint is 
            * selected from the Setpoint Array        
        */
        
        float T = Tmp.get_temperature();          // Reading Temperature as a floating variable
        float SP_2 = Setpoint[2];                 // Reading the Mode Setpoint from the Array
            if (T > SP_2+1){                      // If Temp is above the setpoint
                Clg_LED = 0;                      // Enable the Cooling LED
                Htg_LED = 1;                      // Disable other LED's
                Ready_LED = 1;
                //serial.printf("Cooling");       // Debugging Print
                              }
            else if (T < SP_2-1){                 // If Temp is below the setpoint
                Htg_LED = 0;                      // Enable the Heating LED
                Clg_LED = 1;                      // Disable other LED's
                Ready_LED = 1;
                //serial.printf("Heating");       // Debugging Print
                                   }
            else {                                // If none of the conditions are satisfied
                Clg_LED = 1;                      // Disable Heating & cooling LED's
                Htg_LED = 1;                    
                 }
}
void T_SP_Pg3()
{
        /** Mode Select = Boiling water
          * When a new mode is selected the LCD screen will update in order 
          * to assist the user with the water temperature in order to provide
          * Assistance, Safety and Comfort
        */
        
    float T = Tmp.get_temperature();                              // Reading Temperature as a floating variable
    float SP_3 = Setpoint[2];                                     // Reading the Mode Setpoint from the Array 
    char buffer[14];                                              // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14 Max amound of Characters) 
        
        int  length = sprintf(buffer,"T=%.2F 'C",T);              // print the temperature from the float variable T
        if (length <= 14);                                        // Ensuring string will fit on the screen (Printing at x=0)
            lcd.printString(buffer,18,0);                         // Display string on screen, Determine Co-ordinates (..,Column, Row)
            //serial.printf("    T = %f C\n",T);                  // Debugging Print
            
            length = sprintf(buffer,"SP=%.2f 'C",SP_3);           // print the Setpoint from the Setpoint Variable
        if (length <= 14)                                         // Ensuring string will fit on the screen (Printing at x=0)                                                                  
            lcd.printString(buffer,13,1);                         // Display string on screen, Determine Co-ordinates (..,Column, Row)
            //serial.printf("    T = %f C\n",SP_3);               // Debugging Print
}
void HtgClg_Pg3()
{
        /** Water Temperature Control 
            * Control Mode which enables LED's if the temperature goes outside
            * of the +/- Setpoint Tolerance.
            * Dependant on the Mode Application will depend on which setpoint is 
            * selected from the Setpoint Array        
        */
        
        float T = Tmp.get_temperature();          // Reading Temperature as a floating variable
        float SP_3 = Setpoint[2];                 // Reading the Mode Setpoint from the Array
            if (T > SP_3+1){                      // If Temp is above the setpoint
                Clg_LED = 0;                      // Enable the Cooling LED
                Htg_LED = 1;                      // Disable other LED's
                Ready_LED = 1;
                //serial.printf("Cooling");       // Debugging Print
                              }
            else if (T < SP_3-1){                 // If Temp is below the setpoint
                Htg_LED = 0;                      // Enable the Heating LED
                Clg_LED = 1;                      // Disable other LED's
                Ready_LED = 1;
                //serial.printf("Heating");       // Debugging Print
                                   }
            else {                                // If none of the conditions are satisfied
                Clg_LED = 1;                      // Disable Heating & cooling LED's
                Htg_LED = 1;                    
                 }
}