#include "mbed.h"
 #include "MFRC522.h"

 //KL25Z Pins for MFRC522 SPI interface
 #define SPI_MOSI    p5
 #define SPI_MISO    p6
 #define SPI_SCLK    p7
 #define SPI_CS      p21
 DigitalOut LedRed   (LED1);
 DigitalOut LedGreen (LED2);
  #define MF_RESET    p8
 //#define UART_RX     p27
//#define UART_TX     p28

 //Serial     DebugUART(UART_TX, UART_RX);
 MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCLK, SPI_CS, MF_RESET);

 int main(void) {
   // Set debug UART speed
   //DebugUART.baud(115200);

   // Init. RC522 Chip
   RfChip.PCD_Init();

   while (true) {
     LedRed   = 1;
     LedGreen = 1;

     // Look for new cards
     if ( ! RfChip.PICC_IsNewCardPresent())
     {
       wait_ms(500);
       continue;
       
     }
     LedRed   = 0;

     // Select one of the cards
     if ( ! RfChip.PICC_ReadCardSerial())
     {
       wait_ms(500);
       continue;
      
     }
     LedRed   = 1;
     LedGreen = 0;

     // Print Card UID
     printf("Card UID: ");
     for (uint8_t i = 0; i < RfChip.uid.size; i++)
     {
       printf(" %X", RfChip.uid.uidByte[i]);
     }
     printf("\n\r");

   }
 }