//***************** Capteur HDC1080 - Température ***************************//

#include "mbed.h"
#include "HDC1080.h"
 
#define     HDC_TEMP_OFF        0x00
#define     HDC_HUMID_OFF       0x01
#define     HDC_CONFIG_OFF      0x02
#define     HDC_MANID_OFF       0xFE
#define     HDC_SER_OFF_FIRST   0xFB
#define     HDC_SER_OFF_MID     0xFC
#define     HDC_SER_OFF_LAST    0xFD
#define     I2C_FREQ            100000
#define     CHIP_ADDRESS        (0x40 << 1)   // décalage d'un bit pour obtenir l'adresse I2C 

char HDC_COMMN = HDC_MANID_OFF;
const float HDC_CHIP_ERROR = -255;
const unsigned long HDC_CHIP_SER_ERROR = 0;
char Buffer[5];
 
 
HDC1080::HDC1080(PinName sda, PinName slc) : I2C(sda,slc) 
{
    memset(Buffer,'\0',5);
    Buffer[0] = HDC_CONFIG_OFF;
    this->frequency(I2C_FREQ);
    int res = this->write(CHIP_ADDRESS, Buffer, 2);
    printf("HDC Constructor Initialization  : Res =%d\r\n", res);
}
 
int HDC1080::ReadSignature(void)
{ 
    uint16_t  Manufacturer_ID = read2Bytes(CHIP_ADDRESS, HDC_MANID_OFF);
    if (Manufacturer_ID == 0) {
     
        printf("Error  reading HDC Manufacturer ID\r\n");
       
        return (int) HDC_CHIP_ERROR;
    } else {  
           
        printf("Manufacturer_ID  :%x\r\n", (int) Manufacturer_ID);
      
        return Manufacturer_ID;
    }    
}  
    
    
    
    
    
 float HDC1080::readTemperature()
{
    uint16_t  rawT = read2Bytes(CHIP_ADDRESS, HDC_TEMP_OFF);
    if (rawT == 0) {
       
        printf("error in reading  chip Temp\r\n");
       
        return HDC_CHIP_ERROR;
    } else {
        float temp = ((float) rawT / pow(2.0f, 16.0f)) * 165.0f - 40.0f;
        
        printf("Temperature   : %0.3f\r\n", temp);
        
        return temp;
    }
}   
    
       
    
 float HDC1080::readHumidity()
{
    uint16_t  rawH = read2Bytes(CHIP_ADDRESS, HDC_HUMID_OFF);
    if (rawH == 0) {
       
        printf("error in reading  chip Temp\r\n");
       
        return HDC_CHIP_ERROR;
    } else {
        float humidity = ((float) rawH / pow(2.0f, 16.0f)) * 100.0f;
        
        printf("Humidity   : %0.3f\r\n", humidity);
        
        return humidity;
    }
}   
    
    unsigned long HDC1080::readSerialNumber(void)
{    
    wait(0.015);
    memset(Buffer,0,4);
    Buffer[0] = HDC_MANID_OFF;
    int res = this->write(CHIP_ADDRESS, Buffer, 1);
    if (res != 0) {      
     
      printf("Error writing chip addr res=%d\r\n", res);
    
      return (unsigned long) HDC_CHIP_SER_ERROR;
    }      
 
    wait(0.015);
    memset(Buffer,0,4);
    res = this->read(CHIP_ADDRESS, Buffer,4);
    if (res != 0) {
     
      printf("Errot reading chip serial res=%d#\r\n", res);
     
      return (unsigned long) HDC_CHIP_SER_ERROR;
    }
      
//    unsigned long rawser = Buffer[0] << 16 | Buffer[1] << 8 | Buffer[0];
      unsigned long rawser = Buffer[2] << 16 | Buffer[1] << 8 | Buffer[0];
  
    printf("Serial Number is =%lu\r\n", rawser);
   
    return rawser;
}
    
    
    //Membres functions private 
    
    uint16_t HDC1080::read2Bytes(int chip_addr, int offset)
{
    memset(Buffer,0,3);
    // envoyer adresse de la puce vers le bus 
    Buffer[0] = offset;
    int res =this->write(chip_addr, Buffer, 1);
    if (res != 0) {
       
        printf("error Communicating  to chip %d offst=%d\r\n", chip_addr, offset);
       
        return 0;
    }
    // lecture data
    wait(0.015);
    memset(Buffer,0,3);
    res = this->read(CHIP_ADDRESS, Buffer,2);
    if (res != 0) {
        printf("error Communicating to  chip %d offst=%d\r\n", chip_addr, offset);
        return 0;
    }
    return  Buffer[0] << 8 | Buffer[1];
}
 
            