//*****************Capteur BMP280 - pression atmosphérique ***************************//

#ifndef MBED_BMP280_H
#define MBED_BMP280_H
 
#include "mbed.h"
  
#define DEFAULT_SLAVE_ADDRESS (0x77) // adresse I2C BMP280
 
#ifdef _DEBUG
extern Serial pc;
#define DEBUG_PRINT(...) pc.printf(__VA_ARGS__)
#else
#define DEBUG_PRINT(...)
#endif
 
class BMP280
{
    public:
 
        // Créer une instance BMP280 connectée aux pin I2C spécifiés avec l'adresse I2C déclarée par défaut
        BMP280(PinName sda, PinName scl, char slave_adr = DEFAULT_SLAVE_ADDRESS); 
     
        // Créer une instance BMP280 connectée à l'objet I2C (instance) et connecté à l'adresse I2C déclarée par défaut
        BMP280(I2C &i2c_obj, char slave_adr = DEFAULT_SLAVE_ADDRESS);
 
        // Destructeur de BME280
        virtual ~BMP280();
 
        // Initialisation du capteur BME280 et lire les paramètres pour la calibration
        void initialize(void);
 
        // Lecture de la température en cours (en degré) du capteur BME280
        float getTemperature(void);
 
        // Lecture de la pression en cours (en hectopascam) du capteur BME280
        float getPressure(void);
 
        //Lecture de l'humidité actuelle (en %) du capteur BME280
        //float getHumidity(void);
 
    private:
 
        I2C         *i2c_p;
        I2C         &i2c;
        char        address;
        uint16_t    dig_T1;
        int16_t     dig_T2, dig_T3;
        uint16_t    dig_P1;
        int16_t     dig_P2, dig_P3, dig_P4, dig_P5, dig_P6, dig_P7, dig_P8, dig_P9;
        uint16_t    dig_H1, dig_H3;
        int16_t     dig_H2, dig_H4, dig_H5, dig_H6;
        int32_t     t_fine;
 
};
 
#endif // MBED_BME280_H