#include "mbed.h"
#include "BMP280.h"

#define BMP_TMP_ID 0x8
#define BMP_PRES_ID 0x9

//declarations
Serial bluetooth(p9, p10);      //tx, rx
CAN can(p30,p29);               //CAN
I2C i2c(p9,p10);                //SDA, SCL
BMP280 bmp(i2c);                //Default address = 0x76


int main()
{

    //Configuration Serial
    bluetooth.baud(56000);
    //bluetooth.format(8, SerialBase::None, 1);
    //bluetooth.set_flow_control(SerialBase::Disabled, NC, NC);

    //Configuration bus CAN
    can.frequency(125000); //vitesse du bus CAN 125kHz
    can.reset();

    //bmp.initialize();

    //declaration des variables d'affichage
    float BMPTemp = 0;
    float BMPPressure = 0;

    //affichage de la variable de pression
    while(1) {
        //BMPTemp = (bmp.getTemperature() - 32) / 1.8f;
        BMPPressure = bmp.getPressure();
        //bluetooth.printf("Temp: %f, Pressure: %f\r\n",BMPTemp, BMPPressure);
        
        bluetooth.printf("Pressure: %f\r\n",BMPPressure);
        

        can.write(CANMessage(BMP_TMP_ID, (char*)&BMPTemp, sizeof(BMPTemp)/sizeof(char)));
        wait(0.1); //Need waits for some reason, without them the data doesnt always arrive in a neat order
        can.write(CANMessage(BMP_PRES_ID, (char*)&BMPPressure, sizeof(BMPPressure)/sizeof(char)));
        wait(0.1);
    }
}
