#include "mbed.h"
#include "EthernetNetIf.h"
//#include "HTTPClient.h"
#include "HTTPServer.h"
#include "RPCFunction.h"
#include "x10rf.h"

EthernetNetIf eth(
    IpAddr(192,168,1,25), //IP Address
    IpAddr(255,255,255,0), //Network Mask
    IpAddr(192,168,1,1), //Gateway
    IpAddr(192,168,1,1)  //DNS
);
//HTTPClient http;
HTTPServer svr;

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");

LocalFileSystem fs("webfs");

//Create a function of the required format
void rpcX10rf(char * input, char * output);
//Attach it to an RPC object
RPCFunction rpc_foo(&rpcX10rf, "rpcX10rf");

void rpcX10rf(char * input, char * output) {
char houseCode;
short int numberCode, action;
    printf("%s\r\n", input);
    sscanf(input, "  %c,%d,%d", &houseCode, &numberCode, &action);
    printf("%c, %d,%d\r\n", houseCode, numberCode, action);
    // calls the X10RFLib
    SendX10rf( houseCode, numberCode, action);
    
    //nothing to send back - sprintf(output, "%i, %i", x, y );
}

int main() {
    Base::add_rpc_class<DigitalOut>();
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("\r\nSetup OK\r\n");

    FSHandler::mount("/webfs", "/files"); //Mount /webfs path on /files web path
    FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path

    //svr.addHandler<SimpleHandler>("/hello");
    svr.addHandler<RPCHandler>("/rpc");
    svr.addHandler<FSHandler>("/files");
    svr.addHandler<FSHandler>("/"); //Default handler
    //Example : Access to mbed.htm : http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm
    svr.bind(80);

    printf("Listening...\n");

    Timer tm;
    tm.start();
    //Listen indefinitely
    while (1) {
        Net::poll();
        if (tm.read()>.5) {
            led1=!led1; //Show that we are alive
            tm.start();
        }
    }
}