// Interface Lib to X10 RF transmiter

#include "mbed.h"

DigitalOut led_2(LED2, "led2");
DigitalOut led_3(LED3, "led3");

DigitalOut RF_TX(p19);
DigitalOut RF_Alim(p18);

void SendX10RF_bit(unsigned int databit);
void SendX10byte(unsigned int data8);
void SendX10Cmd(unsigned int data);
void SendX10RF();


//-----------------------------------------------------------------------------
// http://idobartana.com/hakb/x10rf.htm
// ftp://ftp.x10.com/pub/manuals/cm17a_protocol.txt
unsigned int EncodeX10rf(char houseCode, int numberCode, int action)
{// action : 1 : On, 0 : Off, 2 : BRIGHT , 3 : DIM
unsigned int order, add;
    switch (houseCode)
        {
        case 'A' : order= 0x6000; break;
        case 'B' : order= 0xE000; break;
        case 'C' : order= 0x2000; break;
        case 'D' : order= 0xA000; break;
        case 'E' : order= 0x1000; break;
        case 'F' : order= 0x9000; break;
        case 'G' : order= 0x5000; break;
        case 'H' : order= 0xD000; break;
        case 'I' : order= 0x7000; break;
        case 'J' : order= 0xF000; break;
        case 'K' : order= 0x3000; break;
        case 'L' : order= 0xB000; break;
        case 'M' : order= 0x0000; break;
        case 'N' : order= 0x8000; break;
        case 'O' : order= 0x4000; break;
        case 'P' : order= 0xC000; break;
        }
    switch (numberCode)
        {
        case 1 : add= 0x0000; break;
        case 2 : add= 0x0010; break;
        case 3 : add= 0x0008; break;
        case 4 : add= 0x0018; break;
        case 5 : add= 0x0040; break;
        case 6 : add= 0x0050; break;
        case 7 : add= 0x0048; break;
        case 8 : add= 0x0058; break;
        case 9 : add= 0x0400; break;
        case 10: add= 0x0410; break;
        case 11: add= 0x0408; break;
        case 12: add= 0x0418; break;
        case 13: add= 0x0440; break;
        case 14: add= 0x0450; break;
        case 15: add= 0x0448; break;
        case 16: add= 0x0458; break;
        }
     order |= add;
    if (action==0) order |= 0x0020;
    return order;   
}
//-----------------------------------------------------------------------------
void SendX10rf(char houseCode, int numberCode, int action)
{   // action : 1 : On, 0 : Off, 2 : BRIGHT , 3 : DIM
    printf( "h=%c U=%d R=%d    Order=%X\r\n", houseCode, numberCode, action, EncodeX10rf(houseCode, numberCode, action));
//    SendX10Cmd(0x6010);        // A2 ON
//    SendX10Cmd(0x6000);        // A1 ON
    SendX10Cmd( EncodeX10rf(houseCode, numberCode, action));
}
//-----------------------------------------------------------------------------
void SendX10RF_bit(unsigned int databit)
{
    // envoi un 1
    RF_TX=1;
    wait_us(560);        // 0.56 ms
    RF_TX=0;
    wait_us(560);        // 0.56 ms
    // si c'est un 0
    if (!databit)        wait_us(1120);        // 0.56*2 = 1.12 ms si un zero
}
//-----------------------------------------------------------------------------
void SendX10byte(unsigned int data8)
{
unsigned int j, k;
    for (j=0; j<8; j++)
        {
        k=(data8 & 0x0080 )==0x0080;
        SendX10RF_bit(k);
        data8=data8 << 1;
        }
}
//-----------------------------------------------------------------------------
void SendX10Cmd(unsigned int data)
{
unsigned int Cmd8;
    RF_Alim=1;            // Alimente le transmetteur RE8=ON
//    wait_ms(20);        // >20 ms
    wait_ms(10);        // >10 ms
    wait_ms(10);        // >10 ms
// en-tête
    RF_TX=1;
    wait_us(8960);        // 8.96 ms
    RF_TX=0;
    wait_us(4500);        // 4.5 ms
    Cmd8=data>>8;                    // send les Hi
    SendX10byte(~Cmd8);
    SendX10byte(Cmd8);
    Cmd8=(data) & 0xFF;        // send les Low
    SendX10byte(~Cmd8);
    SendX10byte(Cmd8);
    SendX10RF_bit(1);            // 1 à la fin ??
    wait_us(1120);        // 1.12 ms
    RF_Alim=0;            // Eteint transmetteur RE8=OFF
}
//-----------------------------------------------------------------------------
void SendX10RF()
{
//    SendX10Cmd(0x6000);        // A1 ON
//    SendX10Cmd(0x6020);        // A1 OFF
    SendX10Cmd(0x6010);        // A2 ON
//    SendX10Cmd(0x6030);        // A2 OFF
//    SendX10Cmd(0x6090);        // A2 DIM+
//    SendX10Cmd(0x60B0);        // A2 DIM-

//http://idobartana.com/hakb/x10rf.htm
//10101111 11011101 01010101 11011111 10101101 01010101 <-A1 OFF cmd (as seen on RF, RIGHT bit first !)
//00000100 11111011 00000110 11111001    A1 OFF (as RIGHT bit first !)
// byte 1   byte 2   byte 3   byte 4
//bit  function
//0    always 0
//1    always 0
//2    always 0                               
//3    bit B1 of unit number
//4    bit B0 of unit number    
//5    1 for OFF command.                    DIM B2 ON/OFF B0 B1 <--(unit number -1= 0bB2B1B0  )
//6    bit B2 of unit number ------------------>|
//7    1 for DIM (if bit 5=1) or BRIGHT (if bit 5=0) command

// à l'envers aussi mais bytes inversées
//A- 00001 ON
//00032: 11111001 00000110 11111111 00000000    0x6000
//A- 00001 OFF
//00032: 11111001 00000110 11111011 00000100    0x6020
//A- 00002 ON
//00032: 11111001 00000110 11110111 00001000    0x6080
//A- 00002 OFF
//00032: 11111001 00000110 11110011 00001100    0x60C0
//A- 00002 DIM+
//00032: 11111001 00000110 11110111 00001000    0x6090
//http://camelspit.org/modified-x10-rf-transmitter/
}
//---------------------------------------------------------------------
