#include "sx12xx.h"

#ifdef TARGET_FF_ARDUINO    /* pins of SX126xDVK1xAS board */
    SPI spi(D11, D12, D13); // mosi, miso, sclk
    //           spi, nss, busy, dio1
    SX126x radio(spi,  D7,   D3,   D5 );
    #define CHIP_TYPE_SX1262        0
    #define CHIP_TYPE_SX1261        1
    DigitalIn chipType(A2);
    AnalogIn xtalSel(A3);
    DigitalOut antswPower(D8);
#endif /* TARGET_FF_ARDUINO */

/**********************************************************************/
volatile bool txDone;

void txDone_callback()
{
    txDone = true;
}

int main()
{
    uint8_t seq = 0;
    
    printf("\r\nreset-tx ");

    radio.setStandby(STBY_XOSC);
    radio.setPacketType(PACKET_TYPE_LORA);
    radio.setMHz(915.5); 

    {
        ModulationParams_t mp;

        mp.lora.spreadingFactor = 11;
        mp.lora.bandwidth = LORA_BW_500;
        mp.lora.codingRate = LORA_CR_4_5;
        mp.lora.LowDatarateOptimize = 0;

        radio.xfer(OPCODE_SET_MODULATION_PARAMS, 4,0, mp.buf);
    }

    if (chipType == CHIP_TYPE_SX1262)
        radio.set_tx_dbm(true, 22);
    else
        radio.set_tx_dbm(false, 14);


    {    
        PacketParams_t p;

        p.lora.PreambleLengthHi = 0;
        p.lora.PreambleLengthLo = 8;
        p.lora.HeaderType = HEADER_TYPE_VARIABLE_LENGTH;
        /* constant payload length of one byte */
        p.lora.PayloadLength = 1;
        p.lora.CRCType = LORA_CRC_ON;
        p.lora.InvertIQ = STANDARD_IQ;

        radio.xfer(OPCODE_SET_PACKET_PARAMS, 6,0, p.buf);
    }

                
    antswPower = 1;
    radio.SetDIO2AsRfSwitchCtrl(1);
    
    radio.txDone = txDone_callback;
       
    for (;;) {  
     
        uint8_t buf[2];
        buf[0] = 0; // TX base address
        buf[1] = 0; // RX base address
        radio.xfer(OPCODE_SET_BUFFER_BASE_ADDR, 2,0, buf);
        {    
       
    }
       
        radio.tx_buf[0] = seq;  /* set payload */
        txDone = false;
        radio.start_tx(1);   /* begin transmission */
        
        printf("sent\r\n");
        while (!txDone) {
            radio.service();
        }
        printf("tx %x\r\n", seq);
        printf("got-tx-done\r\n");
        
        wait(0.5);  /* throttle sending rate */
        seq++;  /* change payload */
    }
}

