#include "sx12xx.h"

DigitalOut myled(LED1);

#ifdef TARGET_FF_ARDUINO    /* pins of SX126xDVK1xAS board */
    SPI spi(D11, D12, D13); // mosi, miso, sclk
                   //spi, nss, busy, dio1
    SX126x radio(spi, D7, D3, D5);

    #define CHIP_TYPE_SX1262        0
    #define CHIP_TYPE_SX1261        1
    DigitalIn chipType(A2);
    AnalogIn xtalSel(A3);
    DigitalOut antswPower(D8);
#endif /* TARGET_FF_ARDUINO */

/**********************************************************************/

void rx_done(uint8_t size, float rssi, float snr)
{
    unsigned i;

    myled.write(!myled.read()); // toggle LED

    printf("rssi:%.1fdBm, snr:%.1fdB   ", rssi, snr);
    for (i = 0; i < size; i++) {
        printf("%02x ", radio.rx_buf[i]);
    }
    printf("\r\n");
}


int main()
{   
    printf("\r\nreset-rx\r\n");
    
    radio.setStandby(STBY_XOSC);
    radio.setPacketType(PACKET_TYPE_LORA);
    radio.setMHz(915.0); 

    {
        ModulationParams_t mp;

        mp.lora.spreadingFactor = 7;
        mp.lora.bandwidth = LORA_BW_125;
        mp.lora.codingRate = LORA_CR_4_5;
        mp.lora.LowDatarateOptimize = 0;

        radio.xfer(OPCODE_SET_MODULATION_PARAMS, 4, mp.buf);
    }

    {    
        PacketParams_t p;

        p.lora.PreambleLengthHi = 0;
        p.lora.PreambleLengthLo = 8;
        p.lora.HeaderType = HEADER_TYPE_VARIABLE_LENGTH;
        p.lora.PayloadLength = 0x40;    // max limit in rx
        p.lora.CRCType = CRC_ON;
        p.lora.InvertIQ = STANDARD_IQ;

        radio.xfer(OPCODE_SET_PACKET_PARAMS, 6, p.buf);
    }
    
    antswPower = 1;
    radio.SetDIO2AsRfSwitchCtrl(1);

    radio.rxDone = rx_done;

    radio.start_rx(RX_TIMEOUT_CONTINUOUS);
    
     for (;;) {  
     
//     PacketParams_t p;

 //       p.lora.PreambleLengthHi = 0;
  //      p.lora.PreambleLengthLo = 8;
  //      p.lora.HeaderType = HEADER_TYPE_VARIABLE_LENGTH;
  //      p.lora.PayloadLength = 0x40;    // max limit in rx
  //      p.lora.CRCType = CRC_ON;
  //      p.lora.InvertIQ = STANDARD_IQ;

 //       radio.xfer(OPCODE_SET_PACKET_PARAMS, 6, p.buf);
     
    
          
        radio.service();
         uint8_t buf[2];
        buf[0] = 0; // TX base address
        buf[1] = 0; // RX base address
      radio.xfer(OPCODE_SET_BUFFER_BASE_ADDR, 2, buf);
    }
}
