#ifndef __BLESLAVESERVICE_H__
#define __BLESLAVESERVICE_H__

#include "ble/GattService.h"
#include "ble/GattCharacteristic.h"
#include <BleMasterService.h>

/* Attribute value format of the STAR_CHAR */   
/* Timestamp | Node ID | Type ID | value   | Type ID | value   | Type ID | value   | */
/* 2 bytes   | 2 bytes | 1 byte  | x bytes | 1 byte  | x bytes | 1 byte  | x bytes | */
#define STAR_CHAR_MAX_VALUE_LEN   20

#define uint8_tNAME_BLESTAR1           'B','l','e','S','t','a','r','1'


/* Store Value into a buffer in Little Endian Format */
#define STORE_LE_16(buf, val)    ( ((buf)[0] =  (uint8_t) (val)     ) , \
                                   ((buf)[1] =  (uint8_t) (val>>8)  ) )

#define STORE_LE_32(buf, val)    ( ((buf)[0] =  (uint8_t) (val)     ) , \
                                   ((buf)[1] =  (uint8_t) (val>>8)  ) , \
                                   ((buf)[2] =  (uint8_t) (val>>16) ) , \
                                   ((buf)[3] =  (uint8_t) (val>>24) ) )

#define STORE_BE_32(buf, val)    ( ((buf)[3] =  (uint8_t) (val)     ) , \
                                   ((buf)[2] =  (uint8_t) (val>>8)  ) , \
                                   ((buf)[1] =  (uint8_t) (val>>16) ) , \
                                   ((buf)[0] =  (uint8_t) (val>>24) ) )   
                                   
                                   



typedef BLEProtocol::AddressBytes_t tBDAddr;
                                   
 /* MANUFACTURER_SPECIFIC_DATA */
extern uint8_t manuf_data[6];
                                   
                                   
                                   
                                   
/* BLE Slave Service exported types */
typedef struct {
  uint8_t data_length;
  uint8_t *attribute_value;
  tBDAddr devAddr;
  uint16_t attribute_handle;  
} NotificationData_t;
   
typedef struct {
  uint8_t  is_discoverable;
  uint8_t  is_connected;  
  uint16_t conn_handle;
  uint16_t star_hw_serv_handle;
  uint16_t star_data_char_handle;
  uint16_t star_config_char_handle;
  uint8_t  star_data_char_notify;
  uint8_t  star_config_value[3];
  uint8_t  star_config_value_len;
  NotificationData_t notification_data;
} SlaveDevice_t;


/* This struct owns the Change_Notification_Status() parameters */
typedef struct {
    uint8_t     *att_data; 
    uint8_t     *attr_value; 
    uint16_t    conn_handle; 
    uint8_t     i; 
    uint32_t    feature_mask; 
    uint8_t     frequency;
}ChangeNotificationQueue;




/* ---- BLE Slave Service exported functions ---- */
/* Set the device as a slave in discoverable mode */   
void setSlaveDiscoverable                   (void);

/* Stop advertising */
void stopAdv                                (void);

/* Sets some notification properties */
void setNotificationProperty                (uint16_t conn_handle, uint8_t i, uint32_t feature_mask, 
                                             uint8_t command, uint8_t data);
/* Disable all notifications */
void disableAllNotifications                (void);

/* This function enables or disables the new peripheral scanning */
void setNewNodesScanning                    (uint8_t enabled);

/* This function forwards to the peripheral device the command coming from the Cloud */
void Forward_Command_To_BlueNRG             (uint8_t* data_ptr, uint8_t data_length);

/* This function is called when an attribute gets modified */
void AttributeModified_CB                   (const GattWriteCallbackParams* param);

/* Notification callbacks */
void onUpdatesDisabledCallback              (Gap::Handle_t handle);
void onUpdatesEnabledCallback               (GattAttribute::Handle_t handle);

/* Retrieve the device index from the peripheral device address */
uint8_t Get_Device_Index_From_Addr          (uint8_t *addr);

/* This function is called to Enable/Disable MIC/PRX/AGM/SFusion notifications */
void Change_Notification_Status             (uint8_t *att_data, uint8_t  *attr_value, uint16_t conn_handle, uint8_t i, 
                                             uint32_t feature_mask, uint8_t frequency);

/* Add all services using a vendor specific UUIDs */
void addAllServices                         (void);

/* Forwards to master all notifications from peripherals */
//void notifyMaster                       (uint8_t data_length, uint8_t* attribute_value, GattCharacteristic *pCharac);
void notifyMaster                           (uint8_t data_length, uint8_t* attribute_value, uint16_t attribute_handle);

/* Function used to call Attribute_Modified_CB outside the callback call */
void createAttribute_Modified_CB_Prototype  (uint16_t handle, uint8_t data_length, uint8_t *att_data);




                             





#endif /*__BLESLAVESERVICE_H__*/