// By Lorenzo Cervelli - Sept.2018
// OK su STM32-F401RE

#include "mbed.h"

// Display 8x8 con Max7219
#include "maxrefdes99.h"

// Sensore di temperatura con Max6675
#include "max6675.h"

// Per gestire la SD
#include "SDFileSystem.h"

// Per il pulsante 'on board'
InterruptIn my_button(USER_BUTTON);
bool Btn = 0;

// Per la SD
FILE *fp;
Serial pc(USBTX, USBRX);

// Per il tempo di funzionamento (da quando e' alimentato)
Timer t;

void pressed()  // Per il pulsante 'on board'
{
    // Resetto
    if (Btn==0)
    { 
        Btn=1;
        
        // Rimuovo il file precedente
        remove("/sd/sdtest.txt");
        wait(1);  // Lascio il tempo al file-system
        
        // Apro il file sulla SD x la scrittura
        printf(" OK, writing to SD card... \r\n");
        fp = fopen("/sd/sdtest.txt", "w");
        wait(2);  // Lascio il tempo al file-system
        
        // Faccio partire il tempo
        t.start();
    }
    else
    { 
        Btn=0;
        
        // Chiudo il file
        fclose(fp);
        printf(" OK successfully saved! \r\n");
        
        // Lascio il tempo al file-system       
        wait(1);
            
        // Fermo il tempo
        t.stop();
                
        // Leggo tutto il file delle temperature e mostro sulla seriale
        int c;
        pc.printf("\n Reading from SD card... \r\n");
        pc.printf(" ----- BEGIN ----- \r\n");
        fp = fopen("/sd/sdtest.txt", "r");    
        if (fp) 
        {
            while ((c = getc(fp)) != EOF)
                pc.putc(c);
            fclose(fp);
        }
        pc.printf(" ----- END ----- \r\n");
    }
}

int main(void)
{       
    // Sensore di temperatura con Max6675 (Morpho Connectors su F401RE)
    SPI spi(PC_12, PC_11, PC_10);  // MOSI, MISO, SCLK        
    max6675 max(spi, PA_14);       // CS
    
    // Scheda di memoria SD (Arduino Connectors su F401RE)
    SDFileSystem sd(D11, D12, D13, D8, "sd");// MOSI, MISO, SCK, CS         
                                    
    // Settaggi SPI per 8x8 Led matrix Max7219 (Morpho Connectors su F401RE)
    // PB_15 --> DIN  (MOSI)
    // PB_13 --> CLK  (SCK)
    // PB_1  --> LOAD (CS)
    // PB_14 --> MISO 
    Max7219 display(PB_15, PB_14, PB_13, PB_1);   
    
    //struct for holding MAX7219 configuration data
    max7219_configuration_t display_config;
        
    // MAX7219 configuration data
    display_config.decode_mode = 0;                             // no BCD decode
    display_config.intensity  = Max7219::MAX7219_INTENSITY_F;   // max intensity
    display_config.scan_limit = Max7219::MAX7219_SCAN_8;        // scan all digits
    
    // MAX7219 set number of MAX7219 devices being used
    display.set_num_devices(1);
    
    // MAX7219 config display 
    display.init_display(display_config);
    
    // MAX7219 ensure all data registers are 0
    display.display_all_off();
    display.enable_display();
    
    // MAX7219 variables
    uint32_t user_input = 0;
    char user_char;
    char *p_str;                        
    
    // MAX7219 Luminosita' (value from 0 to 15)
    display_config.intensity = 5;
    display.init_display(display_config);           
        
    // MAX7219 Posizione di partenza (value from 1 to 32)
    user_char = 1;                                
    print_char(&display, user_input, user_char);
            
    // MAX7219 Contatore per utilizzare l'ultima riga della matrice 8x8
    int Cur=1;
    
    // Set button 'on board'
    my_button.fall(&pressed);

    // Ciclo continuo
    while(1)
    {    
        int cnt;
        int idx;
                
        // Leggo la temperatura del Max6675
        float TC = max.read_temp();
        // Lascio il tempo al sensore di temperatura
        wait(0.5); 
        
        // Stampo sulla seriale (Temperatura con 2 digits dopo la virgola e Time con 3 digits dopo la virgola)
        printf(" Temperature(C): %.2f  Time(Sec): %.3f \r\n", TC, t.read());
                
        // Scrivo nel file sulla SD
        if (Btn==1)
        {
            // Scrivo nel file sulla SD
            if (fp != NULL) 
            {        
                fprintf(fp, "Temperature(C): %.2f  Time(Sec): %.3f \r\n", TC, t.read());
                
                // Lascio il tempo al file-system       
                wait(0.1);
                
                // Accendo i digit dell'ultima riga della matrice in sequenza per far vedere che sto' registrando
                if (Cur==1){ display.write_digit(1, 8, 0x01); }  // n of matrix, column, byte
                if (Cur==2){ display.write_digit(1, 7, 0x01); }  // n of matrix, column, byte
                if (Cur==3){ display.write_digit(1, 6, 0x01); }  // n of matrix, column, byte
                if (Cur==4){ display.write_digit(1, 5, 0x01); }  // n of matrix, column, byte
                if (Cur==5){ display.write_digit(1, 4, 0x01); }  // n of matrix, column, byte
                if (Cur==6){ display.write_digit(1, 3, 0x01); }  // n of matrix, column, byte
                if (Cur==7){ display.write_digit(1, 2, 0x01); }  // n of matrix, column, byte
                if (Cur==8)
                { 
                    display.write_digit(1, 1, 0x01);  // n of matrix, column, byte
                    Cur=0;
                }
                // Incremento il contatore per utilizzare l'ultima riga della matrice 8x8
                Cur++;
            } 
            else 
            {
                int f;
                for(f = 0; f <= 9; f++) 
                {
                    display.write_digit(1, f, 0x01);
                }
        
                printf(" Write failed! \r\n");
                Btn=0;
            }
            
            // Tempo accensione led
            wait(0.5);
            
            printf(" Press button to stop saving \r\n");
        }
        else
        {            
            printf(" Press button to save \r\n");
        }
                   
        // Floating to Char
        char array[6];  // Numero dei digits (virgola compresa)
        snprintf(array, sizeof(array), "%f", TC);
                
        // Concatenzaione tra Float e String in un nuovo Char
        char* Aggiunta="^C  ";                      // NB: Deve finire con 2 spazi alla fine
        char dest[sizeof(array)+sizeof(Aggiunta)];  // Size dell'array precedente + size di quello dellaggiunta
        strcpy( dest, array );
        strcat( dest, Aggiunta );      
        
        // Faccio il reverse del testo
        size_t l = strlen(dest);
        char* r = (char*)malloc((l + 1) * sizeof(char));
        r[l] = '\0';
        int i;
        for(i = 0; i < l; i++) 
        {
            r[i] = dest[l - 1 - i];
        }
        // Riassegno
        p_str = r;
                
        // Testo nello shift register
        print_string(&display, user_input, p_str);
            
        // Valore per scorrere l'intero testo
        cnt=strlen(r)*6;  // num char *6 (5 char + 1 space)
        for(idx = 0; idx < cnt; idx++)
        {
            // Scorro la matrice
            shift_display_right(&display, 1, 50);           
        } 
    }
    
}
