#include "mbed.h"

class IsA : BusOut{
    
    IsA():BusOut(LED1, LED2, LED3, LED4){};
    
    void LedOff(){write(0x00);}
    
    void LedOn(int lVal){write(lVal)};
    void LedOn(){write(0x0f);}
    
    };

class IsAnEvent : public InterruptIn {
        volatile int16_t _pressed;
        void _RisingISR(); 
    public:
        IsAnEvent() : InterruptIn(p15) {};
        IsAnEvent(PinName pin) : InterruptIn(pin) {
             rise(callback(this, &IsAnEvent::_RisingISR)); 
            _pressed=0; 
        };
        int CheckFlag();
        void InitIsr();
};

void IsAnEvent::InitIsr() { 
    rise(callback(this, &IsAnEvent::_RisingISR)); 
}

void IsAnEvent::_RisingISR() {
    wait_ms(50);
    if( read() )
        _pressed = true;
}
int IsAnEvent::CheckFlag() {
    if( _pressed ) { 
        _pressed = false; 
        return 1; 
    }
    return 0;
}

int main() {
    
    enum STM {INIT, EIN, AUS };
    
    while(1) {

    }
}
