#include "STM_Fahrrad_Licht.h"

StateDefine::StateDefine()
{
    _stmTimer.start();
    _curLEDPos = 1;
    _timerval = 0.1;
}

void StateDefine::st_off(void)
{
    _STMLed.setLED(0);
}

void StateDefine::st_all(void)
{
    _STMLed.setLED(7);
}

void StateDefine:: st_ll()
{
    if(_stmTimer >= _timerval || _stmTimer <= 0) {

        _curLEDPos--;

        if(_curLEDPos >= 1 && _curLEDPos <= 4) {
            ;
            _stmTimer.reset();
            _STMLed.setLED(_curLEDPos);
        } else {
            _stmTimer.reset();
            _curLEDPos = 4;
            _STMLed.setLED(_curLEDPos);
        }

    }
}

void StateDefine:: st_lr()
{
    if(_stmTimer >= _timerval || _stmTimer <= 0) {

        _curLEDPos++;

        if(_curLEDPos >= 1 && _curLEDPos <= 4) {
            ;
            _stmTimer.reset();
            _STMLed.setLED(_curLEDPos);
        } else {
            _stmTimer.reset();
            _curLEDPos = 1;
            _STMLed.setLED(_curLEDPos);
        }

    }
}

void StateDefine:: st_blinki()
{

    if(_stmTimer >= 0.5 || _stmTimer <= 0) {

        if(_curLEDPos == 1) {
            _curLEDPos++;
            _STMLed.setLED(7);
            _stmTimer.reset();
        } else {
            _curLEDPos = 1;
            _STMLed.setLED(0);
            _stmTimer.reset();
        }
    }
}

void StateDefine:: st_defblinki()
{

    if(_stmTimer >= _timerval || _stmTimer <= 0) {

        if(_curLEDPos == 1) {
            _curLEDPos++;
            _STMLed.setLED(7);
            _stmTimer.reset();
        } else {
            _curLEDPos = 1;
            _STMLed.setLED(0);
            _stmTimer.reset();
        }
    }
}

void StateDefine:: st_policelight()
{

    if(_stmTimer >= 0.25 || _stmTimer <= 0) {

        if(_curLEDPos == 1) {
            _curLEDPos++;
            _STMLed.setLED(5);
            _stmTimer.reset();
        } else {
            _curLEDPos = 1;
            _STMLed.setLED(6);
            _stmTimer.reset();
        }
    }

}

void StateDefine:: STATEChange(CurState aCS , float aCurTimerVal){
    
    _timerval = aCurTimerVal;
    
    switch(aCS){
        case OFF: st_off(); break;
        case ALL: st_all(); break;
        case LL: st_ll(); break;
        case LR: st_lr(); break;
        case BLINKI: st_blinki(); break;
        case DEFBLINKI: st_defblinki(); break;
        case POLICELIGHT: st_policelight();break;
        }
    
    
    }
