/*
// --- DA Tschuchnik Danner --- Library für die Brushlessmotoren von LHI ---
//
// Simple Libary für die Brushless-Motoren, Dokumentation im Code
// Coding by JuyN::GumM
*/

/*
* Example
*
*  Motor_Lib Brshlss(p21, p22, p23, p24);                Initialisiere Objekt Brshlss auf den PWM-Pin's P21 bis P24...
*  Brshlss.setAllMotor(1500, 1500, 1500, 1500);           Setze alle Motoren auf halbe Leistung...
*  wait(5);
*  if(Brshlss.getMotorVal(LeftFront) >= 1400){
*  Brshlss.setMotor(LeftFront, 1200); }                  Schalte den linken, vorderen Motor auf 1200 us...
*  Brshlss.setAllZero();                                 Schalte alle Motoren aus (Notstopp)...
*
*/


#include "mbed.h"

// Enum Define für die Motoren um das Anspreche der Motoren zu erleichtern...
enum MOTOR{LeftFront, RightFront, LeftBack, RightBack};

class Motor_obj{
    public:
    // Konstuktor für die Motoren, Ausgänge definiert als PWMOut [ PPM-Modulation ]...
    Motor_obj(PinName mLF, PinName mRF, PinName mLB, PinName mRB);
    
    // Lese den momentan gesetzten Wert eines einzelnen Motors aus...
   int getMotorVal(MOTOR mMotor);
   
   // Lese die momentan gesetzten Werte aller Motoren aus...
   void getAllMotorVal(int mAry[4]);
   
   // Setze den Wert für einen einzelnen Motor...
    void setMotor(MOTOR mMotor, int mMotorVal);
    
    // Setzte die Werte für alle Motoren...
    void setAllMotor(int mMotorLF, int mMotorRF, int mMotorLB, int mMotorRB);
    
    // Schalte alle Motoren aus [NOTSTOPP]...
    void setAllZero(void);
    
    private:
    int _CurrentPPW[4];

    protected:
    PwmOut _MotorLF;
    PwmOut _MotorRF;
    PwmOut _MotorLB;
    PwmOut _MotorRB;
    
    
    };

