#include "Brushless_DC_LIB.h"

Motor_obj::Motor_obj(PinName mLF, PinName mRF, PinName mLB, PinName mRB): _MotorLF(mLF), _MotorRF(mRF), _MotorLB(mLB), _MotorRB(mRB){
    _MotorLF.period_us(2000); _MotorLF.pulsewidth_us(1000);_CurrentPPW[0] = 1000;
    _MotorRF.period_us(2000); _MotorRF.pulsewidth_us(1000);_CurrentPPW[1] = 1000;
    _MotorLB.period_us(2000); _MotorLB.pulsewidth_us(1000);_CurrentPPW[2] = 1000;
    _MotorRB.period_us(2000); _MotorRB.pulsewidth_us(1000);_CurrentPPW[3] = 1000;
    }
    
int Motor_obj:: getMotorVal(MOTOR mMotor){
    
    switch (mMotor){
        case LeftFront: return _CurrentPPW[0]; 
        case RightFront: return _CurrentPPW[1]; 
        case LeftBack: return _CurrentPPW[2]; 
        case RightBack: return _CurrentPPW[3]; 
        }
    return 0;
    
    }
void Motor_obj:: getAllMotorVal(int mAry[4]){
    
        for(int i = 0; i <=4; i++) mAry[i] = _CurrentPPW[i];
        }
    
void Motor_obj:: setMotor(MOTOR mMotor, int mMotorVal){
    
    switch (mMotor){
        
        case LeftFront:{_MotorLF.pulsewidth_us(mMotorVal); _CurrentPPW[0] = mMotorVal ;break;}
        case RightFront:{_MotorRF.pulsewidth_us(mMotorVal); _CurrentPPW[1] = mMotorVal ; break;}
        case LeftBack:{_MotorLB.pulsewidth_us(mMotorVal); _CurrentPPW[2] = mMotorVal ; break;}
        case RightBack:{_MotorRB.pulsewidth_us(mMotorVal); _CurrentPPW[3] = mMotorVal ; break;}
        
        }
    
    }
    
void Motor_obj:: setAllMotor(int mMotorLF, int mMotorRF, int mMotorLB, int mMotorRB){
    
    _MotorLF.pulsewidth_us(mMotorLF); _CurrentPPW[0] = mMotorLF;
    _MotorRF.pulsewidth_us(mMotorRF); _CurrentPPW[1] = mMotorRF; 
    _MotorLB.pulsewidth_us(mMotorLB); _CurrentPPW[2] = mMotorLB; 
    _MotorRB.pulsewidth_us(mMotorRB); _CurrentPPW[3] = mMotorRB; 
    
    }
    
void Motor_obj:: setAllZero(void){
    _MotorRF.pulsewidth_us(0); _MotorLB.pulsewidth_us(0); _MotorRB.pulsewidth_us(0);_MotorLF.pulsewidth_us(0);
    _MotorLF = 0; _MotorRF = 0; _MotorLB = 0; _MotorRB = 0;
 
    
    }
    