/*
// --- DA Tschuchnik Danner --- Library für den AR-610 von Spektrum ---
// Throttle [1100us bis 1900us]
// Aile, Elev & Rudd [1200us bis 1800us]
// Coding by JuyN::GumM
*/
// --------------

#ifndef AR610_LIB_H
#define AR610_LIB_H

#include "mbed.h"

#define CORVALRECIVER 1000000

// --------------

class Receiver_obj{
 
    public:
    
    // * Konstrukt für den AR-610, übergabe als Interruptet-Pin für die Flankenerfassung des PPW-Signals...
    Receiver_obj(PinName InterruptPin);
    // * Erstellung des Dekonstruktors, grüundsätzlich nicht notwendig...
    // ~Receiver_obj();
    
    // * RETURN des korrigierten Wertes (um Faktor 10^6[ Kor von Float auf Int])...
    double CurVal();
    
    // * Startet den Timer wenn ein Interrupt am initialisierten Pin auftritt[steigende Flanke]...
    void STARTTIMER();
    
    // * Stoppt den Timer bei einer aufgetrettenen, fallenden Flanke und speichert diesen Wert in die Variable _CurrentPulseWidth_us...
    void STOPTIMER();
    
    // * Deklarierung des Pin's und des Timers...
    private:
    InterruptIn _interruptin;
    Timer t_Runtime;
    
    // * Deklarierung der Variablen...
    protected:    
    double _CurrentPulseWidth_us;
    
};

// --------------

 
#endif