/*****************************************************************************
*                     Copyright SEEC Ltd
* File:             private_mib.H
* Reference:        A3600-HDR-private_mib
* Content:          Header file for private MIB tree structures
* Version:          0.5
* System:           mbed gnu compiler
* Target Hardware:  mbed LPC1768                                  
* Amendment Record:    
* Author:      L. Smith for all versions unless otherwise specified 
* Initial release
* 0.1         21/11/11: L. Smith
  Derived from snmp_structs.h by Christiaan Simons <christiaan.simons@axon.tv>
* 0.2         28/11/11: L. Smith
  Use SNMP_ENTERPRISE_ID for private mib
* 0.3         30/11/11: L. Smith
  Increase ID range for private MIB scalars from 6 to MAX_PRIVATE_ID
* 0.4         01/12/11: L. Smith
  Replace lwIP SNMP_ENTERPRISE_ID
* 0.5         19/06/12: L. Smith
  Define snmp_obj_id snmptrap_id for use in msg_out.c
*******************************************************************************/

#ifndef __PRIVATE_MIB_H__
#define __PRIVATE_MIB_H__

#include "lwip/opt.h"

#if LWIP_SNMP /* don't build if not configured for use in lwipopts.h */

#include "lwip/snmp.h"
#include "lwip/snmp_structs.h"
#include "IO_file.h"


#ifdef __cplusplus
extern "C" {
#endif

#define SNMP_ENTERPRISE_ID  26381       // v0.4: replaces lwIP PEN from mib2.c
#define MAX_PRIVATE_ID      9           // v0.5: max number of scalars in private MIB
#define MAX_IO_TABLE        32          // v0.3: max number of I/O to be shown in table

/** v0.5: enterprise ID for enterprise specific TRAPs */
static struct snmp_obj_id snmptrap_id = {7,{1,3,6,1,4,1,SNMP_ENTERPRISE_ID}};

/* MIB object instance      from snmp_structs.h
#define MIB_OBJECT_NONE 0 
#define MIB_OBJECT_SCALAR 1
#define MIB_OBJECT_TAB 2

 MIB access types 
#define MIB_ACCESS_READ   1
#define MIB_ACCESS_WRITE  2

 MIB object access 
#define MIB_OBJECT_READ_ONLY      MIB_ACCESS_READ
#define MIB_OBJECT_READ_WRITE     (MIB_ACCESS_READ | MIB_ACCESS_WRITE)
#define MIB_OBJECT_WRITE_ONLY     MIB_ACCESS_WRITE
#define MIB_OBJECT_NOT_ACCESSIBLE 0
*/
/** object definition returned by (get_object_def)() 
struct obj_def
{
   MIB_OBJECT_NONE (0), MIB_OBJECT_SCALAR (1), MIB_OBJECT_TAB (2) 
  u8_t instance;
   0 read-only, 1 read-write, 2 write-only, 3 not-accessible 
  u8_t access;
   ASN type for this object 
  u8_t asn_type;
   value length (host length) 
  u16_t v_len;
   length of instance part of supplied object identifier 
  u8_t  id_inst_len;
   instance part of supplied object identifier 
  s32_t *id_inst_ptr;
};

struct snmp_name_ptr
{
  u8_t ident_len;
  s32_t *ident;
};
*/
/** MIB const scalar (.0) node 
#define MIB_NODE_SC 0x01
* MIB const array node 
#define MIB_NODE_AR 0x02
* MIB array node (mem_malloced from RAM) 
#define MIB_NODE_RA 0x03
* MIB list root node (mem_malloced from RAM) 
#define MIB_NODE_LR 0x04
* MIB node for external objects 
#define MIB_NODE_EX 0x05
*/
/** node "base class" layout, the mandatory fields for a node  
struct mib_node
{
  * returns struct obj_def for the given object identifier 
  void (*get_object_def)(u8_t ident_len, s32_t *ident, struct obj_def *od);
  * returns object value for the given object identifier,
     @note the caller must allocate at least len bytes for the value 
  void (*get_value)(struct obj_def *od, u16_t len, void *value);
  * tests length and/or range BEFORE setting 
  u8_t (*set_test)(struct obj_def *od, u16_t len, void *value);
  * sets object value, only to be called when set_test()  
  void (*set_value)(struct obj_def *od, u16_t len, void *value);  
  * One out of MIB_NODE_AR, MIB_NODE_LR or MIB_NODE_EX 
  u8_t node_type;
   array or max list length 
  u16_t maxlength;
};

* derived node for scalars .0 index 
typedef struct mib_node mib_scalar_node;
*/
/* derived node, points to a fixed size const array
    of sub-identifiers plus a 'child' pointer 
struct mib_array_node
{
   inherited "base class" members 
  void (*get_object_def)(u8_t ident_len, s32_t *ident, struct obj_def *od);
  void (*get_value)(struct obj_def *od, u16_t len, void *value);
  u8_t (*set_test)(struct obj_def *od, u16_t len, void *value);
  void (*set_value)(struct obj_def *od, u16_t len, void *value);

  u8_t node_type;
  u16_t maxlength;

   additional struct members 
  const s32_t *objid;
  struct mib_node* const *nptr;
};

from snmp_structs.h */


extern const struct mib_array_node mib_f3k;     // in private_mib.c
/* v0.2: SNMP_ENTERPRISE_ID .1.3.6.1.4.1 */
const s32_t private_ids[1] = { SNMP_ENTERPRISE_ID };
struct mib_node* const private_nodes[1] = { (struct mib_node*)&mib_f3k };
const struct mib_array_node mib_enterprise = {
  &noleafs_get_object_def,
  &noleafs_get_value,
  &noleafs_set_test,
  &noleafs_set_value,
  MIB_NODE_AR,
  1,
  private_ids,
  private_nodes
};

/* link from enterprises node to SNMP system calls via mib_private */
/* enterprises .1.3.6.1.4 */
const s32_t ent_ids[1] = { 1 };
struct mib_node* const ent_nodes[1] = { (struct mib_node*)&mib_enterprise };
const struct mib_array_node mib_private = {
  &noleafs_get_object_def,
  &noleafs_get_value,
  &noleafs_set_test,
  &noleafs_set_value,
  MIB_NODE_AR,
  1,
  ent_ids,
  ent_nodes
};



#ifdef __cplusplus
}
#endif

#endif /* LWIP_SNMP */

#endif /* __PRIVATE_MIB_H__ */
