/*****************************************************************************
*                     Copyright SEEC Ltd
* File:             IO_file.h
* Reference:        A3600-HDR-IO_file
* Content:          Defines & declarations for HTTP server
* Version:          1.1
* System:           mbed
* Target Hardware:  mbed                                  
* Amendment Record:    
* Author:   L. Smith for all versions unless otherwise specified
  0.0:  18/10/11    Initial tests 
  0.1:  27/10/11    File IO handled by SPI_server class
  0.2:  23/11/11    Add SNMP_FW_VERSION & snmp_fw_version for SNMP enquiry
  0.3   22/12/11    Add new_cmd_idx to indicate which parameter has been set. 
  0.4   27/12/11    Add RUN_SCAN_CMD as index for writing wiring scan enable. 
  0.5   29/12/11    Add net_addrs_set for writing net address to file. 
  0.6   06/01/12    Change main CPU index for version & add indices for net addresses 
  0.7   09/01/12    #define NET_ADDRESS_CHANGE to flag net address changes 
  0.8   30/01/12    Add get_SPI_count() & #define SPI_COUNT = 1752
  0.9   03/05/12    Add definitions used for trap handling
  1.0   15/06/12    Make TRAP_HOST_ADDRESS contiguous with SNMP net addresses
  1.1   18/06/12    Add get_hex_mask for updates from SNMP
*/
/****************************************************************************/

#ifndef IO_FILE_H
#define IO_FILE_H

#include <ctype.h>
#define __DEBUG
#include "dbg/dbg.h"
#include "ipaddr.h"
//#include "rpc.h"

#define H_H_LINK_MSBYTE     62        // index to main CPU head-head link status ms byte
#define H_H_LINK_LSBYTE     63        // DEBUG head-head link status ls byte should be 63
#define MAX_IO_REG_BYTE     63        // Maximum I/O byte checked for changes

#define NET_IP_ADDRESS      1704      // index to main CPU firmware IP addresses
#define NET_ADDRESS_MASK    1708      // index to main CPU firmware address mask
#define NET_GATEWAY_ADDRS   1712      // index to main CPU firmware gateway address
#define NET_DNS_ADDRESS     1716      // index to main CPU firmware DNS address
#define TRAP_HOST_ADDRESS   1720      // index to main CPU firmware address for trap host
#define NET_ADDRESS_CHANGE  1736      // index to main CPU address change flag
#define SPI_COUNT     1752            // index to main CPU SPI write count (activity indicator)
#define VERSION_IDX   1754            // index to main CPU firmware version number
#define RUN_SCAN_IDX  1758            // index to wiring scan enable in main CPU unit 
#define NUM_CARD_IDX  2045            // index to number of card in main CPU unit
#define COMMS_IDX     2046            // index to main CPU Modbus comms type and speed
#define UNIT_ID_IDX   2047            // index to main CPU Modbus comms unit ident
#define MAX_RAM       2048            // size of RAM to copy
#define UNIT_ID_CMD   1               // index to command for Modbus comms unit ident
#define RUN_SCAN_CMD  2               // index to command for 1000PX run scan enable

/* v0.9: Trap definitions addeds */
#define ONLY_TRAP       0           // index for trap when only one used
#define DISABLED        0
#define ENABLED         1


class SPI_Server
{
public:
  ///Instantiates the SPI Server
  SPI_Server( const char * name = NULL );
  virtual ~SPI_Server();
  
  int update_IO_file();
  int read( void );
  void write( int new_offset );
  unsigned char get_byte( unsigned short idx );
  void put_byte( unsigned short idx, unsigned char new_byte );
  unsigned short get_error( void );
  unsigned short get_SPI_count( void );
  unsigned char * net_address_ptr( void );
  unsigned char * trap_host_ptr( void );
  
#if 0
//#ifdef MBED_RPC
  virtual const struct rpc_method *get_rpc_methods();
  static struct rpc_class *get_rpc_class();
#endif    // MBED_RPC

private:
  const char *name;    
  FILE *fp;                           // handle for file to be created
  unsigned short reg_offset;          // register offset for HTTP display
  unsigned char ram_img[ MAX_RAM ];
};

extern unsigned char cmd_buf[];         // store for commands from Ethernet
extern unsigned char new_cmd_idx;
extern const char * snmp_fw_version;

extern unsigned char ip_ad[];
extern unsigned char msk_ad[];
extern unsigned char gwy_ad[];
extern unsigned char dns_ad[];
extern unsigned char th_ad[];
extern unsigned char net_addrs_set;     // flags net address change

extern unsigned char blink_led;

extern SPI_Server fsvr;
extern void check4write_offset( char * req );
extern char * get_hex_mask( void );

extern IpAddr mip;



#endif   // #ifndef IO_FILE_H
