#ifndef Defs_h__
#define Defs_h__

#include "mbed.h"

/*
#define RED         0b1111100000000000
#define GREEN       0b0000011111100000
#define BLUE        0b0000000000011111
#define YELLOW      0b1111111111100000
#define CYAN        0b0000011111111111
#define PURPLE      0b1000000000010000
#define MAGENTA     0b1111100000011111
#define DARKBLUE    0b0000000000010000
#define DUCKGREEN   0b0000010000010000
#define DARKGREEN   0b0000010000000000
#define OLIVE       0b1000010000000000
#define MAROON      0b1000000000000000
#define SLIVER      0b1100011000011000
#define GRAY        0b1000010000010000
#define BLACK       0b0000000000000000
#define WHITE       0b1111111111111111
*/

#define RED         0xF800
#define GREEN       0x07E0
#define BLUE        0x001f
#define YELLOW      0xFFE0
#define CYAN        0x07FF
#define PURPLE      0x8010
#define MAGENTA     0xF81F
#define DARKBLUE    0x0010
#define DUCKGREEN   0x0410
#define DARKGREEN   0x0400
#define OLIVE       0x8400
#define MAROON      0x8000
#define SLIVER      0xC618
#define GRAY        0x8410
#define BLACK       0x0000
#define WHITE       0xffff


// Select one of these defines to set the pixel color order
#define SSD1331_COLORORDER_RGB
// #define SSD1331_COLORORDER_BGR
#if defined SSD1331_COLORORDER_RGB && defined SSD1331_COLORORDER_BGR
  #error "RGB and BGR can not both be defined for SSD1331_COLORODER."
#endif

// Timing Delays
#define SSD1331_DELAYS_HWFILL       (3)
#define SSD1331_DELAYS_HWLINE       (1)

#define SSD1331_CMD_DRAWLINE        0x21
#define SSD1331_CMD_DRAWRECT        0x22
#define SSD1331_CMD_FILL            0x26
#define SSD1331_CMD_SETCOLUMN       0x15
#define SSD1331_CMD_SETROW          0x75
#define SSD1331_CMD_CONTRASTA       0x81
#define SSD1331_CMD_CONTRASTB       0x82
#define SSD1331_CMD_CONTRASTC       0x83
#define SSD1331_CMD_MASTERCURRENT   0x87
#define SSD1331_CMD_SETREMAP        0xA0
#define SSD1331_CMD_STARTLINE       0xA1
#define SSD1331_CMD_DISPLAYOFFSET   0xA2
#define SSD1331_CMD_NORMALDISPLAY   0xA4
#define SSD1331_CMD_DISPLAYALLON    0xA5
#define SSD1331_CMD_DISPLAYALLOFF   0xA6
#define SSD1331_CMD_INVERTDISPLAY   0xA7
#define SSD1331_CMD_SETMULTIPLEX    0xA8
#define SSD1331_CMD_SETMASTER       0xAD
#define SSD1331_CMD_DISPLAYOFF      0xAE
#define SSD1331_CMD_DISPLAYON       0xAF
#define SSD1331_CMD_POWERMODE       0xB0
#define SSD1331_CMD_PRECHARGE       0xB1
#define SSD1331_CMD_CLOCKDIV        0xB3
#define SSD1331_CMD_PRECHARGEA      0x8A
#define SSD1331_CMD_PRECHARGEB      0x8B
#define SSD1331_CMD_PRECHARGEC      0x8C
#define SSD1331_CMD_PRECHARGELEVEL  0xBB
#define SSD1331_CMD_VCOMH           0xBE

#endif
