#include "mbed.h"
//#include "USBSerial.h"
#include "Defs.h"
#include "pinmap.h"
#include "font_watch.h"
#include "DS1337.h"


#define HARD_SPI        1

//USBSerial pc;

// functions
void spiWrite(unsigned char data);
void writeCommand(unsigned char cmd);
void writeData(unsigned char data);
void writeColor(unsigned int data);
void initOLED(void);
void clearOLED(void);
void fillRect(unsigned char x0, unsigned char y0, unsigned char x1, unsigned char y1, unsigned int outlineColor, unsigned int fillColor);
void drawLine(unsigned char x0, unsigned char y0, unsigned char x1, unsigned char y1, unsigned int color);
void fillOLED(unsigned int color);

//DigitalOut blue(P0_20);
DigitalOut white(P0_23);
DigitalOut PowerON_OLED(P0_15);
DigitalOut DC_OLED(P0_11);

DigitalOut CS_OLED(P0_2);


#if HARD_SPI

SPI spi(P0_9, P0_20, P0_10);        // mosi, miso, sclk

#else
DigitalOut MOSI_OLED(P0_9);
DigitalOut SCK_OLED(P0_10);

#endif


DS1337 RTC(P0_5, P0_4);


Serial uart(P0_19, P0_18);


typedef struct{

int hour;
int minutes;
int second;
int year;
int month;
int day;
int week;

}TIME_S;

TIME_S time_now, time_buf;

void time_init()
{
    RTC.readTime();
    time_now.hour      = RTC.getHours();
    time_now.minutes   = RTC.getMinutes();
    time_now.second    = RTC.getSeconds();
    time_now.year      = RTC.getYears();
    time_now.month     = RTC.getMonths();
    time_now.day       = RTC.getDays();
    time_now.week      = RTC.getDayOfWeek(); 
    
    time_buf.hour      = RTC.getHours();
    time_buf.minutes   = RTC.getMinutes();
    time_buf.second    = RTC.getSeconds();
    time_buf.year      = RTC.getYears();
    time_buf.month     = RTC.getMonths();
    time_buf.day       = RTC.getDays();
    time_buf.week      = RTC.getDayOfWeek(); 
}

void time_refresh()
{
    RTC.readTime();
    time_now.hour      = RTC.getHours();
    time_now.minutes   = RTC.getMinutes();
    time_now.second    = RTC.getSeconds();
    time_now.year      = RTC.getYears();
    time_now.month     = RTC.getMonths();
    time_now.day       = RTC.getDays();
    time_now.week      = RTC.getDayOfWeek(); 
}

void setTime()
{
    RTC.setSeconds(50);
    RTC.setMinutes(33);
    RTC.setHours(16);
    RTC.setDays(18);
    RTC.setDayOfWeek(2);
    RTC.setMonths(3);
    RTC.setYears(2014);
    
    RTC.setTime();
}


void drawPix(int x, int y, unsigned int color)
{
    //fillRect(x, y, x, y, color, color);
    
    int x1 = 95-y;
    int y1 = x;
    drawLine(x1, y1, x1, y1, color);
}

void drawBuff(int x, int y, int buf_len, int buf_width, int color, const unsigned char *buff)
{
    for(int i=0; i<(buf_width/8); i++)
    {
        for(int j=0; j<buf_len; j++)
        {
            for(int k=0; k<8; k++)
            {
                int clr_ = (buff[i*buf_len+j] & (0x01<<k)) ? color : 0;
                drawPix(j+x, 8*i+k+y, clr_);
            }
        }
    }
}

void dispFont(int x, int y, int color, const unsigned char *font)
{
    drawBuff(x, y, 11, 32, color, font);
}

void dispFont_small(int x, int y, int color, const unsigned char *font)
{   
    drawBuff(x, y, 8, 16, color, font);
}

void dispChar(char c, int x, int y, int color)
{
    c = c-32;
    drawBuff(x, y, 8, 16, color, font_ascii[c]);
}

unsigned int make_color(unsigned char r, unsigned char g, unsigned char b)
{
    unsigned int color_ = r;

    color_ = r>>3;                              // red
    color_ = color_<<6 | (g>>2);                // green
    color_ = color_<<5 | (b>>3);                // blue

    return color_;
}

void dispString(char *str)
{
    clearOLED();
    
    int color = make_color(255,255, 255);
    
    int x=0, y=0;
    
    int pix = 0;
    
    while(*str)
    {
        dispChar(*str, x, y, make_color(255, 255, 255));
        str++;
        x += 8;
        pix++;
        
        if(pix == 8)
        {
            pix = 0;
            x = 0;
            y += 16;
        }
    }
}

void dispDot(int x, int y, int color)
{
    drawBuff(x, y, 7, 32, color, font_dot);
}

void refresh_time()
{
    int y = 60;
    int color_ = make_color(255, 255, 255); 
    dispFont(0, y, color_, font_num[time_now.hour/10]);
    dispFont(14, y, color_, font_num[time_now.hour%10]);
    dispDot(28, y-2, color_);
    dispFont(38, y, color_, font_num[time_now.minutes/10]);
    dispFont(52, y, color_, font_num[time_now.minutes%10]);
}

void refresh_day()
{
    int color_ = make_color(125, 255, 62);
    
    dispChar('M', 0, 40, color_);
    dispChar('a', 8, 40, color_);
    dispChar('r', 16, 40, color_);

   // dispChar()
   
   dispFont_small(30, 40, color_, font_ascii[time_now.day/10+'0'-32]);
   dispFont_small(38, 40, color_, font_ascii[time_now.day%10+'0'-32]);
}

void show_time()
{
    clearOLED();
    int color_ = make_color(255, 255, 255);
    refresh_day();
    for(int i=0; i<63; i++)
    {
        drawPix(i, 56, color_);
        drawPix(i, 57, color_);
    }
    refresh_time();
}


int main()
{
    uart.baud(38400);
    
    pin_function(P0_15,1);
    pin_function(P0_10,1);

    //pin_mode(P0_15,OpenDrain);
    PowerON_OLED = 0; // power on OLED module
    wait_ms(5);
    PowerON_OLED = 1; // power off OLED module
    wait_ms(5);
    PowerON_OLED = 0; // power on OLED module
    wait_ms(5);

#if HARD_SPI
    spi.format(8,3);
    spi.frequency(1000000);
#else
    SCK_OLED = 1;
    CS_OLED = 1;
#endif
    initOLED();
    clearOLED();
    //unsigned int color = 0;
    // blue = 0;
    
    
    dispString("xadow   smart   watch");
    
    wait(1);
    //setTime();
    time_init();
    show_time();

    char ble_str[40];
    int len_str = 0;
    
    
    drawBuff(12, 0, 40, 40, make_color(153, 153, 255), font_ophw);
    
    for(;;)
    {
        time_refresh();
        
        if(time_now.day != time_buf.day)
        {
            refresh_day();
        }
        
        if(time_now.minutes != time_buf.minutes)
        {
            refresh_time();
        }
        
       wait(0.1);
        
        
        while (uart.readable()) 
        {
            ble_str[len_str++] = uart.getc();
        }
        
        if(len_str == 1 && (ble_str[0] == 't' || ble_str[0] == 'T'))
        {
            time_refresh();
            uart.printf("%d/%d/%d\r\n", time_now.year, time_now.month, time_now.day);
            uart.printf("%d:%d:%d\r\n", time_now.hour, time_now.minutes, time_now.second);
            len_str = 0;
        }
        else if(len_str>0)
        {
            ble_str[len_str] = '\0';
            dispString(ble_str);
            
            wait(3);
            show_time();
            len_str = 0;
            
        }
        
    }
}

void spiWrite(unsigned char data)
{
    
#if HARD_SPI
    
    spi.write(data);
#else
    for(unsigned char i=0;i<8;i++)
    {
        SCK_OLED = 0;
        if(data&0x80)
        {
            MOSI_OLED = 1;
        }
        else
        {
            MOSI_OLED = 0;
        }
        data<<=1;
        wait_us(1);
        SCK_OLED = 1;
        wait_us(1);
    }
#endif
}

void writeCommand(unsigned char cmd)
{
    DC_OLED = 0;
    CS_OLED = 0;
    spiWrite(cmd);
    CS_OLED = 1;
}

void writeData(unsigned char data)
{
    DC_OLED = 1;
    CS_OLED = 0;
    spiWrite(data);
    CS_OLED = 1;
}

void writeColor(unsigned int data)
{
    DC_OLED = 1;
    CS_OLED = 0;
    spiWrite(data>>8);
    spiWrite(data);
    CS_OLED = 1;
}

void initOLED(void)
{
    writeCommand(SSD1331_CMD_DISPLAYOFF);           // 0xAE
    writeCommand(SSD1331_CMD_SETREMAP);             // 0xA0
#if defined SSD1331_COLORORDER_RGB
    writeCommand(0x72);                             // RGB Color
#else
    writeCommand(0x76);                             // BGR Color
#endif
    writeCommand(SSD1331_CMD_STARTLINE);            // 0xA1
    writeCommand(0x0);
    writeCommand(SSD1331_CMD_DISPLAYOFFSET);        // 0xA2
    writeCommand(0x0);
    writeCommand(SSD1331_CMD_NORMALDISPLAY);        // 0xA4
    writeCommand(SSD1331_CMD_SETMULTIPLEX);         // 0xA8
    writeCommand(0x3F);                             // 0x3F 1/64 duty
    writeCommand(SSD1331_CMD_SETMASTER);            // 0xAD
    writeCommand(0x8E);
    writeCommand(SSD1331_CMD_POWERMODE);            // 0xB0
    writeCommand(0x0B);
    writeCommand(SSD1331_CMD_PRECHARGE);    // 0xB1
    writeCommand(0x31);
    writeCommand(SSD1331_CMD_CLOCKDIV);     // 0xB3
    writeCommand(0xF0);  // 7:4 = Oscillator Frequency, 3:0 = CLK Div Ratio (A[3:0]+1 = 1..16)
    writeCommand(SSD1331_CMD_PRECHARGEA);   // 0x8A
    writeCommand(0x64);
    writeCommand(SSD1331_CMD_PRECHARGEB);   // 0x8B
    writeCommand(0x78);
    writeCommand(SSD1331_CMD_PRECHARGEA);   // 0x8C
    writeCommand(0x64);
    writeCommand(SSD1331_CMD_PRECHARGELEVEL);   // 0xBB
    writeCommand(0x3A);
    writeCommand(SSD1331_CMD_VCOMH);        // 0xBE
    writeCommand(0x3E);
    writeCommand(SSD1331_CMD_MASTERCURRENT);    // 0x87
    writeCommand(0x06);
    writeCommand(SSD1331_CMD_CONTRASTA);    // 0x81
    writeCommand(0x91);
    writeCommand(SSD1331_CMD_CONTRASTB);    // 0x82
    writeCommand(0x50);
    writeCommand(SSD1331_CMD_CONTRASTC);    // 0x83
    writeCommand(0x7D);
    writeCommand(SSD1331_CMD_DISPLAYON);    //--turn on oled panel
    
}

void clearOLED(void)
{
    fillRect(0,0,95,63,0,0);
}

void fillOLED(unsigned int color)
{
    fillRect(0,0,95,63,color,color);
}

void fillRect(unsigned char x0, unsigned char y0, unsigned char x1, unsigned char y1, unsigned int outlineColor, unsigned int fillColor)
{
    writeCommand(SSD1331_CMD_FILL);
    writeCommand(0x01);

    writeCommand(SSD1331_CMD_DRAWRECT);
    writeCommand(x0);                           // Starting column
    writeCommand(y0);                           // Starting row
    writeCommand(x1); // End column
    writeCommand(y1); // End row

    // Outline color
    writeCommand((uint8_t)((outlineColor >> 11) << 1));
    writeCommand((uint8_t)((outlineColor >> 5) & 0x3F));
    writeCommand((uint8_t)((outlineColor << 1) & 0x3F));
    // Fill color
    writeCommand((uint8_t)((fillColor >> 11) << 1));
    writeCommand((uint8_t)((fillColor >> 5) & 0x3F));
    writeCommand((uint8_t)((fillColor << 1) & 0x3F));

    // Delay while the fill completes
    wait_ms(SSD1331_DELAYS_HWFILL);
}

void drawLine(unsigned char x0, unsigned char y0, unsigned char x1, unsigned char y1, unsigned int color)
{
    writeCommand(SSD1331_CMD_DRAWLINE);
    writeCommand(x0);
    writeCommand(y0);
    writeCommand(x1);
    writeCommand(y1);
    //wait_ms(SSD1331_DELAYS_HWLINE);
    writeCommand((uint8_t)((color >> 11) << 1));
    writeCommand((uint8_t)((color >> 5) & 0x3F));
    writeCommand((uint8_t)((color << 1) & 0x3F));
    // wait_ms(SSD1331_DELAYS_HWLINE);
}
