#include "mbed.h"
#include "pinmap.h"
#include "font_watch.h"
#include "DS1337.h"
#include "SeeedOLED.h"


#define HARD_SPI        1

DigitalOut blue(P0_20);
DigitalOut white(P0_23);

#define I2C_FREQ            100000

I2C i2c(P0_5, P0_4);        // sda, scl     


DS1337 RTC;

Serial uart(P0_19, P0_18);

typedef struct{

int hour;
int minutes;
int second;
int year;
int month;
int day;
int week;

}TIME_S;

TIME_S time_now, time_buf;

unsigned char disp[1024];

void initDta()
{
    for(int i=0; i<1024; i++)
    {
        disp[i] = 0x00;
    }
}


void display()
{

    for(int i=0; i<8; i++)
    {
        oled.setTextXY(i,0);
        for(int j=0; j<128; j++)
        {
            oled.sendData(disp[128*i+j]);
        }
    }
}


void clearOled()
{
    initDta();
    display();
}




void initOLED()
{
    oled.sendCommand(SeeedOLED_Display_Off_Cmd);    //display off
    wait_ms(5); 
    oled.sendCommand(SeeedOLED_Display_On_Cmd);     //display on
    wait_ms(5); 
    oled.sendCommand(SeeedOLED_Normal_Display_Cmd);  //Set Normal Display (default)
    
    
    oled.setNormalDisplay();       // Set display to normal mode (i.e non-inverse mode)
    oled.setPageMode();            // Set addressing mode to Page Mode
    clearOled();
}

void time_init()
{
    RTC.readTime();
    time_now.hour      = RTC.getHours();
    time_now.minutes   = RTC.getMinutes();
    time_now.second    = RTC.getSeconds();
    time_now.year      = RTC.getYears();
    time_now.month     = RTC.getMonths();
    time_now.day       = RTC.getDays();
    time_now.week      = RTC.getDayOfWeek(); 
    
    time_buf.hour      = RTC.getHours();
    time_buf.minutes   = RTC.getMinutes();
    time_buf.second    = RTC.getSeconds();
    time_buf.year      = RTC.getYears();
    time_buf.month     = RTC.getMonths();
    time_buf.day       = RTC.getDays();
    time_buf.week      = RTC.getDayOfWeek(); 
}

void time_refresh()
{
    RTC.readTime();
    time_now.hour      = RTC.getHours();
    time_now.minutes   = RTC.getMinutes();
    time_now.second    = RTC.getSeconds();
    time_now.year      = RTC.getYears();
    time_now.month     = RTC.getMonths();
    time_now.day       = RTC.getDays();
    time_now.week      = RTC.getDayOfWeek(); 
}

void setTime()
{
    RTC.setSeconds(50);
    RTC.setMinutes(35);
    RTC.setHours(17);
    RTC.setDays(27);
    RTC.setDayOfWeek(4);
    RTC.setMonths(3);
    RTC.setYears(2014);
    
    RTC.setTime();
}


void drawPix(int x1, int y1, unsigned int color)
{
    int x = 127-y1;
    int y = x1;
    
    int n = y/8;
    n = 128*n+x;
    
    int bit = y%8;
    
    
    if(color)
    disp[n] |= (0x01<<bit);
    else
    disp[n] &= ~(0x01<<bit);
}

void drawBuff(int x, int y, int buf_len, int buf_width, int color, const unsigned char *buff)
{
    for(int i=0; i<(buf_width/8); i++)
    {
        for(int j=0; j<buf_len; j++)
        {
            for(int k=0; k<8; k++)
            {
                int clr_ = (buff[i*buf_len+j] & (0x01<<k)) ? color : 0;
                drawPix(j+x, 8*i+k+y, clr_);
            }
        }
    }
}

void dispFont(int x, int y, int color, const unsigned char *font)
{
    drawBuff(x, y, 11, 32, color, font);
}

void dispFont_small(int x, int y, int color, const unsigned char *font)
{   
    drawBuff(x, y, 8, 16, color, font);
}

void dispChar(char c, int x, int y, int color)
{
    c = c-32;
    drawBuff(x, y, 8, 16, color, font_ascii[c]);
}


void dispString(char *str)
{
    clearOled();
    
    int x=0, y=0;
    
    int pix = 0;
    
    while(*str)
    {
        dispChar(*str, x, y, 1);
        str++;
        x += 8;
        pix++;
        
        if(pix == 8)
        {
            pix = 0;
            x = 0;
            y += 16;
        }
    }
}

void dispDot(int x, int y, int color)
{
    drawBuff(x, y, 7, 32, color, font_dot);
}

void refresh_time()
{
    int y = 60+16;
    int color_ =1; 
    dispFont(0, y, color_, font_num[time_now.hour/10]);
    dispFont(14, y, color_, font_num[time_now.hour%10]);
    dispDot(28, y-2, color_);
    dispFont(38, y, color_, font_num[time_now.minutes/10]);
    dispFont(52, y, color_, font_num[time_now.minutes%10]);
}

void refresh_day()
{
    int color_ = 1;
    
    int y = 40+16;
    dispChar('M', 0, y, color_);
    dispChar('a', 8, y, color_);
    dispChar('r', 16, y, color_);

   // dispChar()
   
   dispFont_small(30, y, color_, font_ascii[time_now.day/10+'0'-32]);
   dispFont_small(38, y, color_, font_ascii[time_now.day%10+'0'-32]);
}

void show_time()
{
    clearOled();
    
    drawBuff(12, 0+16, 40, 40, 1, font_ophw);
    int color_ = 1;
    refresh_day();
    for(int i=0; i<63; i++)
    {
        drawPix(i, 56+16, color_);
        drawPix(i, 57+16, color_);
    }
    refresh_time();
}

int main()
{
    uart.baud(38400);
    
    initOLED();
    clearOled();
    
    dispString("xadow   smart   watch");
    display();
    wait(1);
    //setTime();
    time_init();
    show_time();

    char ble_str[40];
    int len_str = 0;

    display();
    for(;;)
    {
        time_refresh();
        
        if(time_now.day != time_buf.day)
        {
            refresh_day();
            display();
        }
        
        if(time_now.minutes != time_buf.minutes)
        {
            refresh_time();
            display();
        }
        
       wait(0.1);
        
        
        while (uart.readable()) 
        {
            ble_str[len_str++] = uart.getc();
        }
        
        if(len_str == 1 && (ble_str[0] == 't' || ble_str[0] == 'T'))
        {
            time_refresh();
            display();
            uart.printf("%d/%d/%d\r\n", time_now.year, time_now.month, time_now.day);
            uart.printf("%d:%d:%d\r\n", time_now.hour, time_now.minutes, time_now.second);
            len_str = 0;
        }
        else if(ble_str[0] == 's' && len_str == 16)             // set time
        {
            // s201403280944003
            RTC.setSeconds((ble_str[13]-'0')*10+(ble_str[14]-'0'));
            RTC.setMinutes((ble_str[11]-'0')*10+(ble_str[12]-'0'));
            RTC.setHours((ble_str[9]-'0')*10+(ble_str[10]-'0'));
            RTC.setDays((ble_str[7]-'0')*10+(ble_str[8]-'0'));
            RTC.setDayOfWeek(ble_str[15]-'0');
            RTC.setMonths((ble_str[5]-'0')*10+(ble_str[6]-'0'));
            RTC.setYears((ble_str[1]-'0')*1000+(ble_str[2]-'0')*100+(ble_str[3]-'0')*10+(ble_str[4]-'0'));
            
            RTC.setTime();
        }
        else if(len_str>0)
        {
            uart.printf("get ok\r\n");
            ble_str[len_str] = '\0';
            dispString(ble_str);
            display();
            wait(3);
            show_time();
            display();
            len_str = 0;
        }
        
    }
}

