/*
  SeeedOLED.cpp - SSD130x OLED Driver Library
  2011 Copyright (c) Seeed Technology Inc.  All right reserved.
  
  Author: Visweswara R
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <mbed.h>
#include "SeeedOLED.h"

// 8x8 Font ASCII 32 - 127 Implemented
// Users can modify this to support more characters(glyphs)
// BasicFont is placed in code memory.

extern I2C i2c;
void SeeedOLED::init(void)
{
    sendCommand(SeeedOLED_Display_Off_Cmd);     //display off
    wait_ms(5); 
    sendCommand(SeeedOLED_Display_On_Cmd);  //display on
    wait_ms(5); 
    sendCommand(SeeedOLED_Normal_Display_Cmd);  //Set Normal Display (default)
}

void SeeedOLED::sendCommand(unsigned char command)
{
    unsigned char dta[] = {SeeedOLED_Command_Mode, command};
    i2c.write(SeeedOLED_Address<<1, (const char *)dta, 2);
}

void SeeedOLED::setBrightness(unsigned char Brightness)
{
   sendCommand(SeeedOLED_Set_Brightness_Cmd);
   sendCommand(Brightness);
}

void SeeedOLED::setHorizontalMode()
{
    addressingMode = HORIZONTAL_MODE;
    sendCommand(0x20);          //set addressing mode
    sendCommand(0x00);          //set horizontal addressing mode
}

void SeeedOLED::setPageMode()
{
    addressingMode = PAGE_MODE;
    sendCommand(0x20);          //set addressing mode
    sendCommand(0x02);          //set page addressing mode
}


void SeeedOLED::setTextXY(unsigned char Row, unsigned char Column)
{
    sendCommand(0xB0 + Row);                        //set page address
    sendCommand(0x00 + (8*Column & 0x0F));          //set column lower address
    sendCommand(0x10 + ((8*Column>>4)&0x0F));       //set column higher address
}

void SeeedOLED::sendData(unsigned char Data)
{
    unsigned char dta[] = {SeeedOLED_Data_Mode, Data};

    i2c.write(SeeedOLED_Address<<1, (const char*)dta, 2);
}


void SeeedOLED::setNormalDisplay()
{
    sendCommand(SeeedOLED_Normal_Display_Cmd);
}

SeeedOLED oled;  // Preinstantiate Objects
