 #include "mbed.h"
 #include "ntc.h" 
 
 #define NTC_VREF        3.3f
  #define NTC_AD_RESOL    65536.0f
 
 // Connections:
 
 //      3.3V (or other Vref)
 //     --+--
 //       |
 //      -+-
 //     |   |
 //     |   |
 //     |   | Series
 //     |   | Resistor
 //     |   |
 //      -+-
 //       |
 //       +---> To A:D
 //       |
 //      -+-
 //     |   |
 //     |   |
 //     |   | NTC
 //     |   | 
 //     |   |
 //      -+-
 //       |
 //     --+--
 //      ---  Ground
 //       -
 
 
 const NTC_TypeDef ntc_my_paramtr = {
   // Vref
   NTC_VREF,           // Vref
   NTC_AD_RESOL,       // A:D 16-bit resolution
   // muRata NCP15XH103J03RC
   10000,              // NTC resistance
   5,                  // NTC initial tolerance
   0,                  // NTC B0/50 (none)
   3380,               // NTC B25/50
   3428,               // NTC B25/80
   3434,               // NTC B25/85
   3355,               // NTC B25/100
   0,                  // NTC other beta (none)
   1,                  // NTC beta tolerance
   // 3.32k 1% 100ppm
   3320,               // Series resistor value
   1,                  // Series resistor tolerance
   100                 // Series Resistor tempco ppm
 };    
 
 NTC ntc(A1, &ntc_my_paramtr);                   //initialize NTC temperature A:D
 
 main() {
     printf("\r\n\r\n-------------------------------------------\r\n");
     printf("NTC Res: %5d   B0/50: %4d   B25/50: %4d   B25/80: %4d   B25/85: %4d   B25/100: %4d   B_OTHER: %4d   SeriesR: %d\r\n", 
                 ntc.get_ntc_res(), ntc.get_ntc_beta(NTC::B0_50 ), ntc.get_ntc_beta(NTC::B25_50 ), ntc.get_ntc_beta(NTC::B25_80 ), ntc.get_ntc_beta(NTC::B25_85 ), 
                 ntc.get_ntc_beta(NTC::B25_100 ), ntc.get_ntc_beta(NTC::B_OTHER ),  ntc.get_series_res());
     uint16_t ad = ntc.read_ad_reg();
     printf("NTC A:D Val: %5d   Volt A:D: %.6f   NTC-R_now: %7.1f    Temp: %+.2f\r\n", ad, 
             NTC_VREF / NTC_AD_RESOL * (float)ad, ntc.get_ntc_res_viaAD(ad), ntc.get_ntc_temp(NTC::B25_85 , ad));
 
     while(1) {
         printf("Temp: %+.2f\r\n", ntc.get_ntc_temp(NTC::B25_85 ));
         wait(2.0);
     }
         
 }  