/*
 * mbed library program
 */

#include    "mbed.h"
#include    "ntc.h"

NTC::NTC(PinName p_ana, const NTC_TypeDef *ntc_parameter) :
    _ana(p_ana)
{
    ntc_set_data = *ntc_parameter;
    rawdata = 0;
}

NTC::NTC(PinName p_ana) :
    _ana(p_ana)
{
    ntc_set_data = ntc_std_paramtr;
    rawdata = 0;
}

uint16_t NTC::read_ad_reg() {
    rawdata = _ana.read_u16();
    return rawdata;
    //return 19918; //85.00c * ntc=10k, b=3434, rser=3320
}

int NTC::get_ntc_res() {
    return ntc_set_data.ntc_res;
}

int NTC::get_ntc_beta(int curve) {
    int beta = 0;
    switch (curve) {
        case B0_50:
            beta = ntc_set_data.ntc_beta_0050;
            break;
        case B25_50:
            beta = ntc_set_data.ntc_beta_2550;
            break;
        case B25_80:
            beta = ntc_set_data.ntc_beta_2580;
            break;
        case B25_85:
            beta = ntc_set_data.ntc_beta_2585;
            break;
        case B25_100:
            beta = ntc_set_data.ntc_beta_25100;
            break;
        case B_OTHER:
            beta = ntc_set_data.ntc_beta_other;
            break;
        default:
            beta = ntc_set_data.ntc_beta_2585;
            break;
    }
    return beta;
}

int NTC::get_series_res() {
    return ntc_set_data.sres_res;
}

float NTC::get_ntc_res_viaAD(uint16_t din) {
    uint16_t ad = din;
    if(din == 0) {
        ad = NTC::read_ad_reg();
    }
    float adv = ntc_set_data.vref / ntc_set_data.ad_resolution * (float)ad;
    return (ntc_set_data.vref / ((ntc_set_data.vref - adv) / ntc_set_data.sres_res) - ntc_set_data.sres_res);
}
    
float NTC::get_ntc_temp(int curve, uint16_t din) {
    int beta = NTC::get_ntc_beta(curve);
    float ntc_res = 0.0f;
    if(din == 0) {
        ntc_res = NTC::get_ntc_res_viaAD();
    } else {
        ntc_res = NTC::get_ntc_res_viaAD(din);
    }
    if(beta == 0) return -100.0f;
    return (beta / (log(ntc_res / (ntc_set_data.ntc_res * exp(-beta / 298.0f)))) - 273.0f);
}


