#if defined(TARGET_K64F)
#include "k64f_EthLink.h"

//--------------------------------------------------------------------------------------------------------------------------------------//
// Constructor

k64fEthLink::k64fEthLink() {
}

//--------------------------------------------------------------------------------------------------------------------------------------//
// Get Ethernet link status on the K64F
/*
int k64fEthLink::GetELink() {
    int mdio_timer = 0;
    uint32_t k64f_mdio_reg = ENET_EIR;
    
    //wait for MDIO interface to be ready
    do {
        k64f_mdio_reg = ENET_EIR;
#ifdef RTOS_H
        Thread::wait(1);
#else   
        wait_ms(1);
#endif
        mdio_timer++;
    } while(((k64f_mdio_reg & MDIO_MII_READY_BIT) == 0) && (mdio_timer < 300));
    if(mdio_timer > 298) {          //average is about 122mS
        return(MDIO_TIMEOUT);       //timeout error
    }   
    
    //get Basic Status Register
    ENET_MMFR = MDIO_GET_LINK_REG;
    wait_us(35);                    //20 is absolute minimum!!
    k64f_mdio_reg = ENET_MMFR;      //get the phy result
    if(k64f_mdio_reg & MDIO_MII_LINK_BITS) return(PHY_UP);
    return(PHY_DOWN);
}
*/
//--------------------------------------------------------------------------------------------------------------------------------------//
// Get Ethernet link status on the K64F
/*
ENET_Type miiSTR = {};

int k64fEthLink::GetELink() {
    int mdio_timer = 0;
    uint32_t k64f_mdio_reg = miiSTR.EIR;
    
    //wait for MDIO interface to be ready
    do {
        k64f_mdio_reg = miiSTR.EIR;
#ifdef RTOS_H
        Thread::wait(1);
#else   
        wait_ms(1);
#endif
        mdio_timer++;
    } while(((k64f_mdio_reg & MDIO_MII_READY_BIT) == 0) && (mdio_timer < 300));
    if(mdio_timer > 298) {          //average is about 122mS
        return(MDIO_TIMEOUT);       //timeout error
    }   
    
    //get Basic Status Register
    miiSTR.MMFR = MDIO_GET_LINK_REG;
    wait_us(35);                    //20 is absolute minimum!!
    k64f_mdio_reg = miiSTR.MMFR;      //get the phy result
    if(k64f_mdio_reg & MDIO_MII_LINK_BITS) return(PHY_UP);
    return(PHY_DOWN);
}
*/
//--------------------------------------------------------------------------------------------------------------------------------------//
// Get Ethernet link status on the K64F

//see: mbed-dev/targets/cmsis/TARGET_K64F/MK64F12.h

int k64fEthLink::GetELink() {
    int mdio_timer = 0;
    uint32_t k64f_mdio_reg = ENET->EIR;
    
    //wait for MDIO interface to be ready
    do {
        k64f_mdio_reg = ENET->EIR;
#ifdef RTOS_H
        Thread::wait(1);
#else   
        wait_ms(1);
#endif
        mdio_timer++;
    } while(((k64f_mdio_reg & MDIO_MII_READY_BIT) == 0) && (mdio_timer < 300));
    if(mdio_timer > 298) {          //average is about 122mS
        return(MDIO_TIMEOUT);       //timeout error
    }   
    
    //get Basic Status Register
    ENET->MMFR = MDIO_GET_LINK_REG;
    wait_us(35);                    //20 is absolute minimum!!
    k64f_mdio_reg = ENET->MMFR;      //get the phy result
    if(k64f_mdio_reg & MDIO_MII_LINK_BITS) return(PHY_UP);
    return(PHY_DOWN);
}

#endif



