#ifndef K64FLINK_H
#define K64FLINK_H

#include "mbed.h"

/** Software routine used to get Ethernet Link status from the KSZ8081 
 *  Ethernet PHY on the FRDM-K64F via the K64F MDIO interface. 
 * 
 * @code
 * //See K64F_EthLink_HelloWorld example
 * @endcode
*/

#define MDIO_MII_READY_BIT      0x00800000  //Bit in ENET_EIR reister that allows access to ENET_MMFR register
#define MDIO_MII_LINK_BITS      0x0004      //Ethernet Link Up / Down bit in Phy's Basic Status Register
#define MDIO_GET_LINK_REG       0x60060000  //command for ENET_MMFR register to read Phy's Basic Status
//                                |-------  ST = 01 start of frame                  31,30
//                                |-------  OP = 10 read                            29,28
//                                 ||-----  PA = 00000 phy address                  27,26,25,24,23
//                                  ||----  RA = 00001 phy register Basic Status    22,21,20,19,18
//                                   |----  TA = 10 turn around                     17,16
//                                    ||||  DATA


    /** k64f_phy_status Ethernet link result enumator
     *
     * @param k64f_phy_status enumator
     *
     */
enum k64f_phy_status {PHY_UP = 0, PHY_DOWN = 1, MDIO_TIMEOUT = 2};

    /** Create k64fEthLink controller class
     *
     * @param k64fEthLink class
     *
     */
class k64fEthLink {

public:
    /** Create a k64fEthLink object
     *
     * @param -none-
     */
    k64fEthLink();
    /** Return Ethernet Link Status
     *
     * @param -none-
     *
     * @return the link status code from enum k64f_phy_status
     */
    int GetELink();

};

#endif