#include "mbed.h"
#include "i2cDevices.h"

extern RawSerial pc;

//--------------------------------------------------------------------------------------------------------------------------------------//
//Constructor

i2c_discovery::i2c_discovery(PinName sda, PinName scl, const char* name)  : _i2c(sda, scl) {
        _i2c.frequency(100000);
}

//--------------------------------------------------------------------------------------------------------------------------------------//
//Display detected i2c device name

int i2c_discovery::showI2C(i2cDeviceFlags& i2cFlags, char addr) {
    switch (addr) {
#ifdef  I2C_0x02
        case 0x02: 
            pc.printf("%s\r\n", I2C_0x02);
            i2cFlags.PCA9955_GGG_ok = true;
            break;
#endif
#ifdef  I2C_0x04
        case 0x04: 
            pc.printf("%s\r\n", I2C_0x04);
            break;
#endif
#ifdef  I2C_0x06
        case 0x06: 
            pc.printf("%s\r\n", I2C_0x06);
            break;
#endif
#ifdef  I2C_0x08
        case 0x08: 
            pc.printf("%s\r\n", I2C_0x08);
            break;
#endif
#ifdef  I2C_0x0A
        case 0x0A: 
            pc.printf("%s\r\n", I2C_0x0A);
            break;
#endif
#ifdef  I2C_0x0C
        case 0x0C: 
            pc.printf("%s\r\n", I2C_0x0C);
            break;
#endif
#ifdef  I2C_0x0E
        case 0x0E: 
            pc.printf("%s\r\n", I2C_0x0E);
            break;
#endif
//----------------------------------------
#ifdef  I2C_0x10
        case 0x10: 
            pc.printf("%s\r\n", I2C_0x10);
            break;
#endif
#ifdef  I2C_0x12
        case 0x12: 
            pc.printf("%s\r\n", I2C_0x12);
            break;
#endif
#ifdef  I2C_0x14
        case 0x14: 
            pc.printf("%s\r\n", I2C_0x14);
            break;
#endif
#ifdef  I2C_0x16
        case 0x16: 
            pc.printf("%s\r\n", I2C_0x16);
            break;
#endif
#ifdef  I2C_0x18
        case 0x18: 
            pc.printf("%s\r\n", I2C_0x18);
            break;
#endif
#ifdef  I2C_0x1A
        case 0x1A: 
            pc.printf("%s\r\n", I2C_0x1A);
            break;
#endif
#ifdef  I2C_0x1C
        case 0x1C: 
            pc.printf("%s\r\n", I2C_0x1C);
            break;
#endif
#ifdef  I2C_0x1E
        case 0x1E: 
            pc.printf("%s\r\n", I2C_0x1E);
            break;
#endif
//----------------------------------------
#ifdef  I2C_0x20
        case 0x20: 
            pc.printf("%s\r\n", I2C_0x20);
            i2cFlags.VEML60xx_ok = true;
            break;
#endif
#ifdef  I2C_0x22
        case 0x22: 
            pc.printf("%s\r\n", I2C_0x22);
            break;
#endif
#ifdef  I2C_0x24
        case 0x24: 
            pc.printf("%s\r\n", I2C_0x24);
            break;
#endif
#ifdef  I2C_0x26
        case 0x26: 
            pc.printf("%s\r\n", I2C_0x26);
            break;
#endif
#ifdef  I2C_0x28
        case 0x28: 
            pc.printf("%s\r\n", I2C_0x28);
            break;
#endif
#ifdef  I2C_0x2A
        case 0x2A: 
            pc.printf("%s\r\n", I2C_0x2A);
            break;
#endif
#ifdef  I2C_0x2C
        case 0x2C: 
            pc.printf("%s\r\n", I2C_0x2C);
            break;
#endif
#ifdef  I2C_0x2E
        case 0x2E: 
            pc.printf("%s\r\n", I2C_0x2E);
            break;
#endif
//----------------------------------------
#ifdef  I2C_0x30
        case 0x30: 
            pc.printf("%s\r\n", I2C_0x30);
            break;
#endif
#ifdef  I2C_0x32
        case 0x32: 
            pc.printf("%s\r\n", I2C_0x32);
            break;
#endif
#ifdef  I2C_0x34
        case 0x34: 
            pc.printf("%s\r\n", I2C_0x34);
            break;
#endif
#ifdef  I2C_0x36
        case 0x36: 
            pc.printf("%s\r\n", I2C_0x36);
            break;
#endif
#ifdef  I2C_0x38
        case 0x38: 
            pc.printf("%s\r\n", I2C_0x38);
            i2cFlags.mma8451cs1_ok = true;
            //fxos8700_ok = true;
            break;
#endif
#ifdef  I2C_0x3A
        case 0x3A: 
            pc.printf("%s\r\n", I2C_0x3A);
            //fxos8700_ok = true;
            break;
#endif
#ifdef  I2C_0x3C
        case 0x3C: 
            pc.printf("%s\r\n", I2C_0x3C);
            //fxos8700_ok = true;
            break;
#endif
#ifdef  I2C_0x3E
        case 0x3E: 
            pc.printf("%s\r\n", I2C_0x3E);
            //fxos8700_ok = true;
            break;
#endif
//----------------------------------------
#ifdef  I2C_0x40
        case 0x40: 
            pc.printf("%s\r\n", I2C_0x40);
            break;
#endif
#ifdef  I2C_0x42
        case 0x42: 
            pc.printf("%s\r\n", I2C_0x42);
            break;
#endif
#ifdef  I2C_0x44
        case 0x44: 
            pc.printf("%s\r\n", I2C_0x44);
            break;
#endif
#ifdef  I2C_0x46
        case 0x46: 
            pc.printf("%s\r\n", I2C_0x46);
            break;
#endif
#ifdef  I2C_0x48
        case 0x48: 
            pc.printf("%s\r\n", I2C_0x48);
            break;
#endif
#ifdef  I2C_0x4A
        case 0x4A: 
            pc.printf("%s\r\n", I2C_0x4A);
            break;
#endif
#ifdef  I2C_0x4C
        case 0x4C: 
            pc.printf("%s\r\n", I2C_0x4C);
            break;
#endif
#ifdef  I2C_0x4E
        case 0x4E: 
            pc.printf("%s\r\n", I2C_0x4E);
            break;
#endif
//----------------------------------------
#ifdef  I2C_0x50
        case 0x50: 
            pc.printf("%s\r\n", I2C_0x50);
            break;
#endif
#ifdef  I2C_0x52
        case 0x52: 
            pc.printf("%s\r\n", I2C_0x52);
            break;
#endif
#ifdef  I2C_0x54
        case 0x54: 
            pc.printf("%s\r\n", I2C_0x54);
            break;
#endif
#ifdef  I2C_0x56
        case 0x56: 
            pc.printf("%s\r\n", I2C_0x56);
            break;
#endif
#ifdef  I2C_0x58
        case 0x58: 
            pc.printf("%s\r\n", I2C_0x58);
            break;
#endif
#ifdef  I2C_0x5A
        case 0x5A: 
            pc.printf("%s\r\n", I2C_0x5A);
            break;
#endif
#ifdef  I2C_0x5C
        case 0x5C: 
            pc.printf("%s\r\n", I2C_0x5C);
            break;
#endif
#ifdef  I2C_0x5E
        case 0x5E: 
            pc.printf("%s\r\n", I2C_0x5E);
            break;
#endif
//----------------------------------------
#ifdef  I2C_0x60
        case 0x60: 
            pc.printf("%s\r\n", I2C_0x60);
            break;
#endif
#ifdef  I2C_0x62
        case 0x62: 
            pc.printf("%s\r\n", I2C_0x62);
            break;
#endif
#ifdef  I2C_0x64
        case 0x64: 
            pc.printf("%s\r\n", I2C_0x64);
            break;
#endif
#ifdef  I2C_0x66
        case 0x66: 
            pc.printf("%s\r\n", I2C_0x66);
            break;
#endif
#ifdef  I2C_0x68
        case 0x68: 
            pc.printf("%s\r\n", I2C_0x68);
            break;
#endif
#ifdef  I2C_0x6A
        case 0x6A: 
            pc.printf("%s\r\n", I2C_0x6A);
            break;
#endif
#ifdef  I2C_0x6C
        case 0x6C: 
            pc.printf("%s\r\n", I2C_0x6C);
            break;
#endif
#ifdef  I2C_0x6E
        case 0x6E: 
            pc.printf("%s\r\n", I2C_0x6E);
            break;
#endif
//----------------------------------------
#ifdef  I2C_0x70
        case 0x70: 
            pc.printf("%s\r\n", I2C_0x70);
            i2cFlags.VEML6070_ok = true;
            break;
#endif
#ifdef  I2C_0x72
        case 0x72: 
            pc.printf("%s\r\n", I2C_0x72);
            break;
#endif
#ifdef  I2C_0x74
        case 0x74: 
            pc.printf("%s\r\n", I2C_0x74);
            break;
#endif
#ifdef  I2C_0x76
        case 0x76: 
            pc.printf("%s\r\n", I2C_0x76);
            break;
#endif
#ifdef  I2C_0x78
        case 0x78: 
            pc.printf("%s\r\n", I2C_0x78);
            break;
#endif
#ifdef  I2C_0x7A
        case 0x7A: 
            pc.printf("%s\r\n", I2C_0x7A);
            break;
#endif
#ifdef  I2C_0x7C
        case 0x7C: 
            pc.printf("%s\r\n", I2C_0x7C);
            break;
#endif
#ifdef  I2C_0x7E
        case 0x7E: 
            pc.printf("%s\r\n", I2C_0x7E);
            break;
#endif
//----------------------------------------
#ifdef  I2C_0x80
        case 0x80: 
            pc.printf("%s\r\n", I2C_0x80);
            i2cFlags.HTU21D_ok = true;
            i2cFlags.INA219_MAX7300_gg_ok = true;
            i2cFlags.INA230_MAX7300_gg_ok = true;
            break;
#endif
#ifdef  I2C_0x82
        case 0x82: 
            pc.printf("%s\r\n", I2C_0x82);
            break;
#endif
#ifdef  I2C_0x84
        case 0x84: 
            pc.printf("%s\r\n", I2C_0x84);
            break;
#endif
#ifdef  I2C_0x86
        case 0x86: 
            pc.printf("%s\r\n", I2C_0x86);
            break;
#endif
#ifdef  I2C_0x88
        case 0x88: 
            pc.printf("%s\r\n", I2C_0x88);
            break;
#endif
#ifdef  I2C_0x8A
        case 0x8A: 
            pc.printf("%s\r\n", I2C_0x8A);
            break;
#endif
#ifdef  I2C_0x8C
        case 0x8C: 
            pc.printf("%s\r\n", I2C_0x8C);
            break;
#endif
#ifdef  I2C_0x8E
        case 0x8E: 
            pc.printf("%s\r\n", I2C_0x8E);
            break;
#endif
//----------------------------------------
#ifdef  I2C_0x90
        case 0x90: 
            pc.printf("%s\r\n", I2C_0x90);
            break;
#endif
#ifdef  I2C_0x92
        case 0x92: 
            pc.printf("%s\r\n", I2C_0x92);
            break;
#endif
#ifdef  I2C_0x94
        case 0x94: 
            pc.printf("%s\r\n", I2C_0x94);
            break;
#endif
#ifdef  I2C_0x96
        case 0x96: 
            pc.printf("%s\r\n", I2C_0x96);
            break;
#endif
#ifdef  I2C_0x98
        case 0x98: 
            pc.printf("%s\r\n", I2C_0x98);
            break;
#endif
#ifdef  I2C_0x9A
        case 0x9A: 
            pc.printf("%s\r\n", I2C_0x9A);
            break;
#endif
#ifdef  I2C_0x9C
        case 0x9C: 
            pc.printf("%s\r\n", I2C_0x9C);
            break;
#endif
#ifdef  I2C_0x9E
        case 0x9E: 
            pc.printf("%s\r\n", I2C_0x9E);
            break;
#endif
//----------------------------------------
#ifdef  I2C_0xA0
        case 0xA0: 
            pc.printf("%s\r\n", I2C_0xA0);
            i2cFlags.eeprom000_ok = true;
            break;
#endif
#ifdef  I2C_0xA2
        case 0xA2: 
            pc.printf("%s\r\n", I2C_0xA2);
            break;
#endif
#ifdef  I2C_0xA4
        case 0xA4: 
            pc.printf("%s\r\n", I2C_0xA4);
            break;
#endif
#ifdef  I2C_0xA6
        case 0xA6: 
            pc.printf("%s\r\n", I2C_0xA6);
            break;
#endif
#ifdef  I2C_0xA8
        case 0xA8: 
            pc.printf("%s\r\n", I2C_0xA8);
            break;
#endif
#ifdef  I2C_0xAA
        case 0xAA: 
            pc.printf("%s\r\n", I2C_0xAA);
            i2cFlags.bq27210_ok = true;
            break;
#endif
#ifdef  I2C_0xAC
        case 0xAC: 
            pc.printf("%s\r\n", I2C_0xAC);
            break;
#endif
#ifdef  I2C_0xAE
        case 0xAE: 
            pc.printf("%s\r\n", I2C_0xAE);
            break;
#endif
//----------------------------------------
#ifdef  I2C_0xB0
        case 0xB0: 
            pc.printf("%s\r\n", I2C_0xB0);
            break;
#endif
#ifdef  I2C_0xB2
        case 0xB2: 
            pc.printf("%s\r\n", I2C_0xB2);
            break;
#endif
#ifdef  I2C_0xB4
        case 0xB4: 
            pc.printf("%s\r\n", I2C_0xB4);
            i2cFlags.ccs811_0_ok = true;
            break;
#endif
#ifdef  I2C_0xB6
        case 0xB6: 
            pc.printf("%s\r\n", I2C_0xB6);
            i2cFlags.ccs811_1_ok = true;
            break;
#endif
#ifdef  I2C_0xB8
        case 0xB8: 
            pc.printf("%s\r\n", I2C_0xB8);
            break;
#endif
#ifdef  I2C_0xBA
        case 0xBA: 
            pc.printf("%s\r\n", I2C_0xBA);
            break;
#endif
#ifdef  I2C_0xBC
        case 0xBC: 
            pc.printf("%s\r\n", I2C_0xBC);
            break;
#endif
#ifdef  I2C_0xBE
        case 0xBE: 
            pc.printf("%s\r\n", I2C_0xBE);
            break;
#endif
//----------------------------------------
#ifdef  I2C_0xC0
        case 0xC0: 
            pc.printf("%s\r\n", I2C_0xC0);
            i2cFlags.mlx90620_ok = true;
            //i2cFlags.PCA9955_GGG_ok = true;
            break;
#endif
#ifdef  I2C_0xC2
        case 0xC2: 
            pc.printf("%s\r\n", I2C_0xC2);
            i2cFlags.SCD30_ok = true;
            break;
#endif
#ifdef  I2C_0xC4
        case 0xC4: 
            pc.printf("%s\r\n", I2C_0xC4);
            break;
#endif
#ifdef  I2C_0xC6
        case 0xC6: 
            pc.printf("%s\r\n", I2C_0xC6);
            break;
#endif
#ifdef  I2C_0xC8
        case 0xC8: 
            pc.printf("%s\r\n", I2C_0xC8);
            break;
#endif
#ifdef  I2C_0xCA
        case 0xCA: 
            pc.printf("%s\r\n", I2C_0xCA);
            break;
#endif
#ifdef  I2C_0xCC
        case 0xCC: 
            pc.printf("%s\r\n", I2C_0xCC);
            break;
#endif
#ifdef  I2C_0xCE
        case 0xCE: 
            pc.printf("%s\r\n", I2C_0xCE);
            break;
#endif
//----------------------------------------
#ifdef  I2C_0xD0
        case 0xD0: 
            pc.printf("%s\r\n", I2C_0xD0);
            i2cFlags.rtcDS_ok = true;
            break;
#endif
#ifdef  I2C_0xD2
        case 0xD2: 
            pc.printf("%s\r\n", I2C_0xD2);
            break;
#endif
#ifdef  I2C_0xD4
        case 0xD4: 
            pc.printf("%s\r\n", I2C_0xD4);
            break;
#endif
#ifdef  I2C_0xD6
        case 0xD6: 
            pc.printf("%s\r\n", I2C_0xD6);
            break;
#endif
#ifdef  I2C_0xD8
        case 0xD8: 
            pc.printf("%s\r\n", I2C_0xD8);
            break;
#endif
#ifdef  I2C_0xDA
        case 0xDA: 
            pc.printf("%s\r\n", I2C_0xDA);
            break;
#endif
#ifdef  I2C_0xDC
        case 0xDC: 
            pc.printf("%s\r\n", I2C_0xDC);
            break;
#endif
#ifdef  I2C_0xDE
        case 0xDE: 
            pc.printf("%s\r\n", I2C_0xDE);
            i2cFlags.mcp7941x_ok = true;
            break;
#endif
//----------------------------------------
#ifdef  I2C_0xE0
        case 0xE0: 
            pc.printf("%s\r\n", I2C_0xE0);
            break;
#endif
#ifdef  I2C_0xE2
        case 0xE2: 
            pc.printf("%s\r\n", I2C_0xE2);
            break;
#endif
#ifdef  I2C_0xE4
        case 0xE4: 
            pc.printf("%s\r\n", I2C_0xE4);
            break;
#endif
#ifdef  I2C_0xE6
        case 0xE6: 
            pc.printf("%s\r\n", I2C_0xE6);
            break;
#endif
#ifdef  I2C_0xE8
        case 0xE8: 
            pc.printf("%s\r\n", I2C_0xE8);
            break;
#endif
#ifdef  I2C_0xEA
        case 0xEA: 
            pc.printf("%s\r\n", I2C_0xEA);
            break;
#endif
#ifdef  I2C_0xEC
        case 0xEC: 
            pc.printf("%s\r\n", I2C_0xEC);
            i2cFlags.bme280_cs0_ok = true;
            break;
#endif
#ifdef  I2C_0xEE
        case 0xEE: 
            pc.printf("%s\r\n", I2C_0xEE);
            i2cFlags.ms5611_ok = true;
            i2cFlags.bme280_cs1_ok = true;
            break;
#endif
//----------------------------------------
#ifdef  I2C_0xF0
        case 0xF0: 
            pc.printf("%s\r\n", I2C_0xF0);
            break;
#endif
#ifdef  I2C_0xF2
        case 0xF2: 
            pc.printf("%s\r\n", I2C_0xF2);
            break;
#endif
#ifdef  I2C_0xF4
        case 0xF4: 
            pc.printf("%s\r\n", I2C_0xF4);
            break;
#endif
#ifdef  I2C_0xF6
        case 0xF6: 
            pc.printf("%s\r\n", I2C_0xF6);
            break;
#endif
#ifdef  I2C_0xF8
        case 0xF8: 
            pc.printf("%s\r\n", I2C_0xF8);
            break;
#endif
#ifdef  I2C_0xFA
        case 0xFA: 
            pc.printf("%s\r\n", I2C_0xFA);
            break;
#endif
#ifdef  I2C_0xFC
        case 0xFC: 
            pc.printf("%s\r\n", I2C_0xFC);
            break;
#endif
#ifdef  I2C_0xFE
        case 0xFE: 
            pc.printf("%s\r\n", I2C_0xFE);
            break;
#endif
//----------------------------------------   
        default:
            pc.printf("%sunknown%s\r\n", DOMAGENTA, DONONE);
            break;
    }
    return(0);    
}

//------------------------------------------------------------------------------
// Clear I2C device flags

void i2c_discovery::clearFlags(i2cDeviceFlags& i2cFlags) {
    i2cFlags.rtcDS_ok = false;
    i2cFlags.ms5611_ok = false;
    i2cFlags.bme280_cs0_ok = false;
    i2cFlags.bme280_cs1_ok = false;
    i2cFlags.mma8451cs1_ok = false;
    i2cFlags.HTU21D_ok = false;
    i2cFlags.PCA9955_GGG_ok = false;
    i2cFlags.VEML60xx_ok = false;
    i2cFlags.VEML6070_ok = false;
    i2cFlags.eeprom000_ok = false;
    i2cFlags.INA219_MAX7300_gg_ok = false;
    i2cFlags.INA230_MAX7300_gg_ok = false;
    i2cFlags.bq27210_ok = false;
    i2cFlags.SCD30_ok = false;
    i2cFlags.ccs811_0_ok = false;
    i2cFlags.ccs811_1_ok = false;
    i2cFlags.mcp7941x_ok = false;
}
    
//------------------------------------------------------------------------------
// Detect I2C device chain.  If i2c chain > 1, return illegal number 255.  Else, 
// return the total number of i2c devices detected

int i2c_discovery::dispI2C(i2cDeviceFlags& i2cFlags) {
    //i2c_discovery::clearFlags(i2cFlags);
    int count = 0;
    for (int address = 2; address < 256; address +=2) {
        char xBuf[2] = { 0, 0 };
        int x2c = _i2c.write(address, xBuf, 1, false);
        if(x2c == 0) {
            pc.printf(" - i2c device found at address 0x%02X  %s", address, DOBLUE);
            showI2C(i2cFlags, address);
            pc.printf("%s", DONONE);
            count++;
        }
    }
    return(count);
}

//------------------------------------------------------------------------------
// Detect I2C device chain

int i2c_discovery::find_i2c(i2cDeviceFlags& i2cFlags) {
    pc.printf("Searching for devices on i2c bus...\n");
    int count = dispI2C(i2cFlags);
    pc.printf("   - %s%2d%s device(s) found on i2c bus\n", DOBLUE, count, DONONE);
    return(count);
}

