#ifndef WATCHDOG_K64F_H
#define WATCHDOG_K64F_H

#include "mbed.h"

/** Routines to set and kick the Watchdog timer for the K64F.
 *
 *   User inputs a value from 1 to 356 seconds when initializing the Watchdog
 *   timer. The user's input number is multiplied by a fixed value and then 
 *   placed into the countdown timer.
 *
 *   The user is responsible for "kicking" the Watchdog before the timeout interval 
 *   expires, otherwise the K64F will automatically reboot.
 *
 * @code
 * #include "mbed.h"
 * #include "Watchdog.h" 
 *
 * Watchdog wdt;
 *
 * int main() {
 *     //initialization code....
 *     wdt.kick(20);           //init the watchdog for a 20 second timeout
 *     while(1) {
 *         wait_ms(1000);      //do some code
 *         wdt.kick();         //kick the watchdog before 20 seconds is up
 *     }
 * }
 * @endcode
 *
 */
/* Watchdog controller class
 */
class Watchdog {

public:
    /** Create a Watchdog object and initialize timeout in seconds
     *
     * @param int timeout in seconds. Range (1 - 356)
     *
     * Note: if value out of range, default value with be 356
     *
     * @return NONE
     */
    void kick(int WDTseconds);
    
    /** Keep alive by kicking the Watchdog occasionally
     *
     * @param NONE
     *
     * @return NONE
     */
    void kick();
    
private:
    /** Disable the watchdog Function
     *
     * @param NONE
     *
     * @return NONE
     */
    void DisableWDOG();
    
    /** Enable the watchdog Function
     *
     * @param NONE
     *
     * @return NONE
     */
    void EnableWDOG();

};   
    
#endif