#include "mbed.h"
#include "Watchdog.h"

#if defined(TARGET_K64F)

void Watchdog::kick(int toVal) {  
    const uint32_t K64FWDONESEC = 0x00B80000;   //approx 1 second delay
    if((toVal < 1) || (toVal > 356)) toVal = 356;
    WDOG_UNLOCK = 0xC520; 
    WDOG_UNLOCK = 0xD928;
    uint32_t wdogCntl = K64FWDONESEC * toVal;
    WDOG_TOVALH = wdogCntl >> 16;
    WDOG_TOVALL = wdogCntl & 0xFFFF;
    EnableWDOG();
}

void Watchdog::kick() {
    WDOG_REFRESH = 0xA602; 
    WDOG_REFRESH = 0xB480; 
}

void Watchdog::DisableWDOG() {   
    WDOG_UNLOCK = 0xC520; 
    WDOG_UNLOCK = 0xD928; 
    WDOG_STCTRLH &= 0xFFFE;
}
    
void Watchdog::EnableWDOG() {   
    WDOG_UNLOCK = 0xC520; 
    WDOG_UNLOCK = 0xD928; 
    WDOG_STCTRLH |= 0x0001;
    kick();
}

#endif  //(TARGET_K64F)
